/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ResolveDbRelationshipDialog;
import org.apache.cayenne.modeler.dialog.objentity.DbRelationshipTargetController;
import org.apache.cayenne.modeler.dialog.objentity.DbRelationshipTargetModel;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfoDialog;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfoModel;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.MultiColumnBrowser;
import org.apache.cayenne.project.NamedObjectFactory;
import org.scopemvc.controller.basic.BasicController;
import org.scopemvc.core.Control;
import org.scopemvc.core.ControlException;
import org.scopemvc.core.View;

public class ObjRelationshipInfoController
extends BasicController
implements TreeSelectionListener {
    public static final String SAVE_CONTROL = "cayenne.modeler.mapObjRelationship.save.button";
    public static final String CANCEL_CONTROL = "cayenne.modeler.mapObjRelationship.cancel.button";
    public static final String NEW_REL_CONTROL = "cayenne.modeler.mapObjRelationship.newrel.button";
    public static final String SELECT_PATH_CONTROL = "cayenne.modeler.mapObjRelationship.select.path.button";
    public static final String REVERT_PATH_CONTROL = "cayenne.modeler.mapObjRelationship.revert.path.button";
    public static final String CLEAR_PATH_CONTROL = "cayenne.modeler.mapObjRelationship.clear.path.button";
    protected ProjectController mediator;

    public ObjRelationshipInfoController(ProjectController mediator, ObjRelationship relationship) {
        this.mediator = mediator;
        ObjRelationshipInfoModel model = new ObjRelationshipInfoModel(relationship);
        this.setModel((Object)model);
    }

    public void startup() {
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getModel());
        ObjEntity target = model.getObjectTarget();
        ObjRelationshipInfoDialog view = new ObjRelationshipInfoDialog();
        this.setView((View)view);
        model.setObjectTarget(target);
        view.getPathBrowser().addTreeSelectionListener(this);
        view.initFromModel();
        super.startup();
    }

    protected void doHandleControl(Control control) throws ControlException {
        if (control.matchesID(CANCEL_CONTROL)) {
            this.shutdown();
        } else if (control.matchesID(SAVE_CONTROL)) {
            this.saveMapping();
        } else if (control.matchesID(NEW_REL_CONTROL)) {
            this.createRelationship();
        } else if (control.matchesID(SELECT_PATH_CONTROL)) {
            this.selectPath();
        } else if (control.matchesID(REVERT_PATH_CONTROL)) {
            this.revertPath();
        } else if (control.matchesID(CLEAR_PATH_CONTROL)) {
            this.clearPath();
        }
    }

    protected void selectPath() {
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getModel());
        model.selectPath();
    }

    protected void revertPath() {
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getModel());
        ((ObjRelationshipInfoDialog)this.getView()).setSelectionPath(model.getSavedDbRelationships());
        model.setDbRelationships(model.getSavedDbRelationships());
    }

    protected void clearPath() {
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getModel());
        ((ObjRelationshipInfoDialog)this.getView()).getPathBrowser().clearSelection();
        model.setDbRelationships(new ArrayList<DbRelationship>());
    }

    protected void saveMapping() {
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getModel());
        if (!((Object)model.getDbRelationships()).equals(model.getSavedDbRelationships()) && JOptionPane.showConfirmDialog((Component)this.getView(), "You have changed Db Relationship path. Do you want it to be saved?", "Save ObjRelationship", 0) == 0) {
            this.selectPath();
        }
        if (model.savePath()) {
            this.mediator.fireObjRelationshipEvent(new RelationshipEvent((Object)Application.getFrame(), (Relationship)model.getRelationship(), model.getRelationship().getSourceEntity()));
        }
        this.shutdown();
    }

    protected void createRelationship() {
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getModel());
        DbRelationship dbRel = model.getLastRelationship();
        DbEntity source = dbRel != null ? (DbEntity)dbRel.getTargetEntity() : null;
        DbRelationshipTargetController targetController = new DbRelationshipTargetController(model.getStartEntity(), source);
        targetController.startup();
        if (!targetController.isSavePressed()) {
            return;
        }
        DbRelationshipTargetModel targetModel = (DbRelationshipTargetModel)((Object)targetController.getModel());
        DbRelationship dbRelationship = (DbRelationship)NamedObjectFactory.createRelationship((Entity)targetModel.getSource(), (Entity)targetModel.getTarget(), (boolean)targetModel.isToMany());
        dbRelationship.setSourceEntity((Entity)targetModel.getSource());
        dbRelationship.setTargetEntity((Entity)targetModel.getTarget());
        dbRelationship.setToMany(targetModel.isToMany());
        targetModel.getSource().addRelationship((Relationship)dbRelationship);
        ResolveDbRelationshipDialog dialog = new ResolveDbRelationshipDialog(dbRelationship);
        dialog.setVisible(true);
        if (dialog.isCancelPressed()) {
            targetModel.getSource().removeRelationship(dbRelationship.getName());
        } else {
            Object[] objectArray;
            MultiColumnBrowser pathBrowser = ((ObjRelationshipInfoDialog)this.getView()).getPathBrowser();
            if (targetModel.isSource1Selected()) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = model.getStartEntity();
            } else {
                objectArray = pathBrowser.getSelectionPath().getPath();
            }
            Object[] oldPath = objectArray;
            EntityTreeModel treeModel = (EntityTreeModel)pathBrowser.getModel();
            treeModel.invalidate();
            pathBrowser.setSelectionPath(new TreePath(new Object[]{model.getStartEntity()}));
            pathBrowser.repaint();
            Object[] path = new Object[oldPath.length + 1];
            System.arraycopy(oldPath, 0, path, 0, path.length - 1);
            path[path.length - 1] = dbRelationship;
            pathBrowser.setSelectionPath(new TreePath(path));
        }
        dialog.dispose();
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath selectedPath = e.getPath();
        if (selectedPath == null || selectedPath.getPathCount() < 2) {
            return;
        }
        Relationship rel = (Relationship)selectedPath.getLastPathComponent();
        DbEntity target = (DbEntity)rel.getTargetEntity();
        ObjRelationshipInfoModel model = (ObjRelationshipInfoModel)((Object)this.getModel());
        Collection objEntities = target.getDataMap().getMappedEntities(target);
        Vector<DbRelationship> relPath = new Vector<DbRelationship>(selectedPath.getPathCount() - 1);
        for (int i = 1; i < selectedPath.getPathCount(); ++i) {
            relPath.add((DbRelationship)selectedPath.getPathComponent(i));
        }
        model.setDbRelationships(relPath);
        model.setObjectTarget(objEntities.size() == 0 ? null : (ObjEntity)objEntities.iterator().next());
        ((ObjRelationshipInfoDialog)this.getView()).updateCollectionChoosers();
    }
}

