/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.conf.DriverDataSourceFactory;
import org.apache.cayenne.conf.JNDIDataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateNodeAction;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.AdapterMapping;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.project.ProjectDataSource;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.wocompat.EOModelProcessor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportEOModelAction
extends CayenneAction {
    private static Log logObj = LogFactory.getLog(ImportEOModelAction.class);
    protected JFileChooser eoModelChooser;

    public static String getActionName() {
        return "Import EOModel";
    }

    public ImportEOModelAction(Application application) {
        super(ImportEOModelAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-eomodel.gif";
    }

    public void performAction(ActionEvent event) {
        this.importEOModel();
    }

    protected void importEOModel() {
        JFileChooser fileChooser = this.getEOModelChooser();
        int status = fileChooser.showOpenDialog(Application.getFrame());
        if (status == 0) {
            FSPath lastDir = this.getApplication().getFrameController().getLastEOModelDirectory();
            lastDir.updateFromChooser(fileChooser);
            File file = fileChooser.getSelectedFile();
            if (file.isFile()) {
                file = file.getParentFile();
            }
            DataMap currentMap = this.getProjectController().getCurrentDataMap();
            try {
                String path = file.getCanonicalPath();
                EOModelProcessor processor = new EOModelProcessor();
                if (currentMap == null) {
                    this.loadDataNode(processor.loadModeIndex(path));
                }
                DataMap map = processor.loadEOModel(path);
                this.addDataMap(map, currentMap);
            }
            catch (Exception ex) {
                logObj.info((Object)"EOModel Loading Exception", (Throwable)ex);
                ErrorDebugDialog.guiException(ex);
            }
        }
    }

    protected void loadDataNode(Map eomodelIndex) {
        String adapter = (String)eomodelIndex.get("adaptorName");
        Map connection = (Map)eomodelIndex.get("connectionDictionary");
        if (adapter != null && connection != null) {
            CreateNodeAction nodeBuilder = (CreateNodeAction)this.getApplication().getAction(CreateNodeAction.getActionName());
            DataNode node = nodeBuilder.buildDataNode();
            if ("JNDI".equalsIgnoreCase(adapter)) {
                node.setDataSourceFactory(JNDIDataSourceFactory.class.getName());
                node.setDataSourceLocation((String)connection.get("serverUrl"));
            } else {
                AdapterMapping adapterDefaults = this.getApplication().getAdapterMapping();
                String cayenneAdapter = adapterDefaults.adapterForEOFPluginOrDriver((String)connection.get("plugin"), (String)connection.get("driver"));
                if (cayenneAdapter != null) {
                    try {
                        Class adapterClass = this.getApplication().getClassLoadingService().loadClass(cayenneAdapter);
                        node.setAdapter((DbAdapter)adapterClass.newInstance());
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                }
                node.setDataSourceFactory(DriverDataSourceFactory.class.getName());
                DataSourceInfo dsi = ((ProjectDataSource)node.getDataSource()).getDataSourceInfo();
                dsi.setDataSourceUrl(this.keyAsString(connection, "URL"));
                dsi.setJdbcDriver(this.keyAsString(connection, "driver"));
                dsi.setPassword(this.keyAsString(connection, "password"));
                dsi.setUserName(this.keyAsString(connection, "username"));
            }
            this.getProjectController().fireDataNodeEvent(new DataNodeEvent((Object)this, node, 2));
            this.getProjectController().fireDataNodeDisplayEvent(new DataNodeDisplayEvent(this, this.getProjectController().getCurrentDataDomain(), node));
        }
    }

    private String keyAsString(Map map, String key) {
        Object value = map.get(key);
        return value != null ? value.toString() : null;
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        return path.firstInstanceOf(DataDomain.class) != null;
    }

    protected void addDataMap(DataMap map, DataMap currentMap) {
        ProjectController mediator = this.getProjectController();
        if (currentMap != null) {
            ArrayList originalOE = new ArrayList(currentMap.getObjEntities());
            ArrayList originalDE = new ArrayList(currentMap.getDbEntities());
            ArrayList originalQueries = new ArrayList(currentMap.getQueries());
            currentMap.mergeWithDataMap(map);
            map = currentMap;
            ArrayList newOE = new ArrayList(currentMap.getObjEntities());
            ArrayList newDE = new ArrayList(currentMap.getDbEntities());
            ArrayList newQueries = new ArrayList(currentMap.getQueries());
            EntityEvent entityEvent = new EntityEvent((Object)Application.getFrame(), null);
            QueryEvent queryEvent = new QueryEvent((Object)Application.getFrame(), null);
            Collection addedOE = CollectionUtils.subtract(newOE, originalOE);
            for (Entity e : addedOE) {
                entityEvent.setEntity(e);
                entityEvent.setId(2);
                mediator.fireObjEntityEvent(entityEvent);
            }
            Collection removedOE = CollectionUtils.subtract(originalOE, newOE);
            for (Entity e : removedOE) {
                entityEvent.setEntity(e);
                entityEvent.setId(3);
                mediator.fireObjEntityEvent(entityEvent);
            }
            Collection addedDE = CollectionUtils.subtract(newDE, originalDE);
            for (Entity e : addedDE) {
                entityEvent.setEntity(e);
                entityEvent.setId(2);
                mediator.fireDbEntityEvent(entityEvent);
            }
            Collection removedDE = CollectionUtils.subtract(originalDE, newDE);
            for (Entity e : removedDE) {
                entityEvent.setEntity(e);
                entityEvent.setId(3);
                mediator.fireDbEntityEvent(entityEvent);
            }
            Collection addedQueries = CollectionUtils.subtract(newQueries, originalQueries);
            for (Query q : addedQueries) {
                queryEvent.setQuery(q);
                queryEvent.setId(2);
                mediator.fireQueryEvent(queryEvent);
            }
            Collection removedQueries = CollectionUtils.subtract(originalQueries, newQueries);
            for (Query q : removedQueries) {
                queryEvent.setQuery(q);
                queryEvent.setId(3);
                mediator.fireQueryEvent(queryEvent);
            }
            mediator.fireDataMapDisplayEvent(new DataMapDisplayEvent(Application.getFrame(), map, mediator.getCurrentDataDomain(), mediator.getCurrentDataNode()));
        } else {
            DataDomain domain = mediator.getCurrentDataDomain();
            map.setName(NamedObjectFactory.createName(DataMap.class, (Object)domain, (String)map.getName()));
            mediator.addDataMap(Application.getFrame(), map);
        }
    }

    public JFileChooser getEOModelChooser() {
        if (this.eoModelChooser == null) {
            this.eoModelChooser = new EOModelChooser("Select EOModel");
        }
        FSPath lastDir = this.getApplication().getFrameController().getLastEOModelDirectory();
        lastDir.updateChooser(this.eoModelChooser);
        return this.eoModelChooser;
    }

    class EOModelChooser
    extends JFileChooser {
        protected FileFilter selectFilter;
        protected JDialog cachedDialog;

        public EOModelChooser(String title) {
            super.setFileFilter(FileFilters.getEOModelFilter());
            super.setDialogTitle(title);
            super.setFileSelectionMode(2);
            this.selectFilter = FileFilters.getEOModelSelectFilter();
        }

        public int showOpenDialog(Component parent) {
            int status = super.showOpenDialog(parent);
            if (status != 0) {
                this.cachedDialog = null;
                return status;
            }
            File file = this.getSelectedFile();
            if (this.selectFilter.accept(file)) {
                this.cachedDialog = null;
                return 0;
            }
            if (file.isDirectory()) {
                this.setCurrentDirectory(file);
            }
            return this.showOpenDialog(parent);
        }

        protected JDialog createDialog(Component parent) throws HeadlessException {
            if (this.cachedDialog == null) {
                this.cachedDialog = super.createDialog(parent);
            }
            return this.cachedDialog;
        }
    }
}

