/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;

public abstract class AbstractRemoveCallbackMethodAction
extends RemoveAction {
    public AbstractRemoveCallbackMethodAction(String actionName, Application application) {
        super(actionName, application);
    }

    public abstract CallbackMap getCallbackMap();

    public String getIconName() {
        return "icon-remove-method.gif";
    }

    public final void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        String[] methods = this.getProjectController().getCurrentCallbackMethods();
        if (methods.length > 0 && (methods.length == 1 && dialog.shouldDelete("callback method", methods[0]) || methods.length > 1 && dialog.shouldDelete("selected callback methods"))) {
            this.removeCallbackMethods(e);
        }
    }

    private void removeCallbackMethods(ActionEvent actionEvent) {
        String[] callbackMethods;
        ProjectController mediator = this.getProjectController();
        CallbackType callbackType = mediator.getCurrentCallbackType();
        for (String callbackMethod : callbackMethods = mediator.getCurrentCallbackMethods()) {
            this.removeCallbackMethod(this.getCallbackMap(), callbackType, callbackMethod);
        }
    }

    public void removeCallbackMethod(CallbackMap map, CallbackType callbackType, String method) {
        ProjectController mediator = this.getProjectController();
        map.getCallbackDescriptor(callbackType.getType()).removeCallbackMethod(method);
        CallbackMethodEvent e = new CallbackMethodEvent(this, null, method, 3);
        mediator.fireCallbackMethodEvent(e);
    }

    public abstract String getActionName(boolean var1);
}

