/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.model.util;

import java.util.Iterator;
import org.scopemvc.core.Selector;

public final class ArraySelectorIterator
implements Iterator {
    private Selector[] selectors;
    private int currentIndex = -1;

    public ArraySelectorIterator(Selector[] selectorArray) {
        this.selectors = selectorArray == null ? new Selector[0] : selectorArray;
        this.currentIndex = 0;
    }

    public boolean hasNext() {
        return this.currentIndex < this.selectors.length;
    }

    public Object next() {
        if (this.currentIndex <= -1 || this.currentIndex >= this.selectors.length) {
            throw new RuntimeException("Iterator past end of Selector list.");
        }
        Selector selector = this.selectors[this.currentIndex];
        ++this.currentIndex;
        return selector;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can't remove Selectors from a model.");
    }
}

