/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.util;

public final class IntPartition {
    private int[] partition;
    private int setCount;

    public IntPartition(int elementCount) {
        this.partition = new int[elementCount];
        this.reset();
    }

    public final int joinSets(int setId1, int setId2) {
        if (setId1 < 0 || setId2 < 0) {
            throw new IndexOutOfBoundsException("setId1=" + setId1 + ", setId2=" + setId2);
        }
        if (setId1 == setId2) {
            return setId1;
        }
        int rank1 = this.partition[setId1];
        int rank2 = this.partition[setId2];
        --this.setCount;
        if (rank2 < rank1) {
            this.partition[setId1] = setId2;
            return setId2;
        }
        if (rank2 == rank1) {
            int n = setId1;
            this.partition[n] = this.partition[n] - 1;
        }
        this.partition[setId2] = setId1;
        return setId1;
    }

    public final int findSetId(int element) {
        if (this.partition[element] < 0) {
            return element;
        }
        this.partition[element] = this.findSetId(this.partition[element]);
        return this.partition[element];
    }

    public final int size() {
        return this.partition.length;
    }

    public final int getSetCount() {
        return this.setCount;
    }

    public final void reset() {
        for (int i = 0; i < this.partition.length; ++i) {
            this.partition[i] = -1;
        }
        this.setCount = this.size();
    }

    public final boolean isSetId(int element) {
        return this.partition[element] < 0;
    }
}

