/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.awt.geom.RectangularShape;
import java.util.Iterator;
import org.objectstyle.ashwood.graph.layout.DigraphLayout;

public class CobbleLayout
extends DigraphLayout {
    private boolean enforceWidth = true;

    public void doLayout() {
        double minX = this.areaBounds.getMinX();
        double minY = this.areaBounds.getMinY();
        double maxX = this.areaBounds.getMaxX();
        double maxY = this.areaBounds.getMaxY();
        double x = minX;
        double y = minY;
        double levelWidth = 0.0;
        double levelHeight = 0.0;
        boolean first = true;
        Iterator i = this.digraph.vertexIterator();
        while (i.hasNext()) {
            Object vertex = i.next();
            RectangularShape shape = (RectangularShape)this.vertexShape.get(vertex);
            double width = shape.getWidth();
            double height = shape.getHeight();
            shape.setFrame(x, y, width, height);
            if (this.enforceWidth) {
                if (!first && shape.getMaxX() > maxX) {
                    x = minX;
                    levelHeight = height;
                    shape.setFrame(x, y += this.verticalSpacing + levelHeight, width, height);
                } else {
                    x += this.horizontalSpacing + width;
                    levelHeight = Math.max(levelHeight, height);
                }
            } else if (!first && y > maxY) {
                y = minY;
                levelWidth = width;
                shape.setFrame(x += this.horizontalSpacing + levelWidth, y, width, height);
            } else {
                y += this.verticalSpacing + height;
                levelWidth = Math.max(levelWidth, width);
            }
            first = false;
        }
    }

    public void setEnforceWidth(boolean enforceWidth) {
        this.enforceWidth = enforceWidth;
    }

    public boolean isEnforceWidth() {
        return this.enforceWidth;
    }
}

