/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class CellEditorForAttributeTable
implements TableCellEditor {
    protected Hashtable editors;
    protected TableCellEditor editor;
    protected TableCellEditor defaultEditor;
    JTable table;

    public CellEditorForAttributeTable(JTable table, JComboBox combo) {
        this.table = table;
        this.editors = new Hashtable();
        this.defaultEditor = combo != null ? new DefaultCellEditor(combo) : new DefaultCellEditor(new JComboBox());
    }

    public void setEditorAt(int row, TableCellEditor editor) {
        this.editors.put(new Integer(row), editor);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    public boolean isCellEditable(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.editor.isCellEditable(anEvent);
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.editor.shouldSelectCell(anEvent);
    }

    protected void selectEditor(MouseEvent e) {
        int row = e == null ? this.table.getSelectionModel().getAnchorSelectionIndex() : this.table.rowAtPoint(e.getPoint());
        this.editor = (TableCellEditor)this.editors.get(new Integer(row));
        if (this.editor == null) {
            this.editor = this.defaultEditor;
        }
    }
}

