/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.awt.Component;
import java.util.EventObject;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.dbimport.DeleteNodeAction;
import org.apache.cayenne.modeler.action.dbimport.EditNodeAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.util.Util;

public class DbImportTreeCellEditor
extends DefaultTreeCellEditor {
    private ProjectController projectController;

    public DbImportTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
        this.setFont(UIManager.getFont("Tree.font"));
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DbImportTreeCellEditor.this.cancelCellEditing();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                this.editingStopped(e);
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        if (this.tree.getSelectionPath() == null) {
            return "";
        }
        DbImportTreeNode node = (DbImportTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        return node.getUserObject();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (value instanceof DbImportTreeNode) {
            value = ((DbImportTreeNode)value).getSimpleNodeName();
        }
        return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (this.tree.getSelectionPath() != null) {
            if (((DbImportTreeNode)this.tree.getSelectionPath().getLastPathComponent()).getUserObject().getClass() == String.class) {
                return false;
            }
            if (this.tree.getSelectionPath().getLastPathComponent() == this.tree.getModel().getRoot()) {
                return false;
            }
        }
        return true;
    }

    private boolean isValidReverseEngineering() {
        try {
            Pattern.compile(super.getCellEditorValue().toString());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        DbImportTreeNode selectedNode;
        if (this.tree.getSelectionPath() == null) {
            return;
        }
        if (!Util.isEmptyString(super.getCellEditorValue().toString()) && !this.insertableNodeExist() && this.isValidReverseEngineering()) {
            EditNodeAction action = this.projectController.getApplication().getActionManager().getAction(EditNodeAction.class);
            action.setActionName(super.getCellEditorValue().toString());
            action.actionPerformed(null);
        } else {
            selectedNode = (DbImportTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            if (Util.isEmptyString(selectedNode.getSimpleNodeName()) || this.insertableNodeExist()) {
                DeleteNodeAction action = this.projectController.getApplication().getActionManager().getAction(DeleteNodeAction.class);
                TreePath parentPath = this.tree.getSelectionPath().getParentPath();
                action.actionPerformed(null);
                this.tree.setSelectionPath(parentPath);
            } else {
                this.tree.startEditingAtPath(this.tree.getSelectionPath());
            }
        }
        if (this.tree.getSelectionPath() != null) {
            selectedNode = (DbImportTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            ((DbImportTree)this.tree).reloadModelKeepingExpanded(selectedNode);
        }
    }

    private boolean equalNodes(int i, DbImportTreeNode parent, DbImportTreeNode selectedElement) {
        return super.getCellEditorValue().toString().equals(((DbImportTreeNode)parent.getChildAt(i)).getSimpleNodeName()) && selectedElement.getUserObject().getClass().equals(((DbImportTreeNode)parent.getChildAt(i)).getUserObject().getClass());
    }

    private boolean insertableNodeExist() {
        DbImportTreeNode selectedElement = this.tree.getSelectionPath() == null ? (DbImportTreeNode)this.tree.getModel().getRoot() : (DbImportTreeNode)this.tree.getSelectionPath().getLastPathComponent();
        int childCount = selectedElement.getParent().getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!this.equalNodes(i, selectedElement.getParent(), selectedElement) || selectedElement.getParent().getChildAt(i) == selectedElement) continue;
            return true;
        }
        return false;
    }

    public void setProjectController(ProjectController projectController) {
        this.projectController = projectController;
    }
}

