/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.List;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.util.CayenneTableModel;

public class CallbackDescriptorTableModel
extends CayenneTableModel<String> {
    private static final int COLUMN_COUNT = 1;
    public static final int METHOD_NAME = 0;
    protected ObjEntity entity;
    protected CallbackDescriptor callbackDescriptor;
    protected CallbackType callbackType;

    public CallbackDescriptorTableModel(ProjectController mediator, Object eventSource, List<String> objectList, CallbackDescriptor callbackDescriptor, CallbackType callbackType) {
        super(mediator, eventSource, objectList);
        this.callbackDescriptor = callbackDescriptor;
        this.callbackType = callbackType;
    }

    @Override
    public void setUpdatedValueAt(Object newVal, int row, int col) {
    }

    @Override
    public Class<String> getElementsClass() {
        return String.class;
    }

    public String getCallbackMethod(int rowIndex) {
        return (String)this.objectList.get(rowIndex);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getCallbackMethod(rowIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.callbackType.getName();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object newVal, int row, int col) {
        String method = (String)newVal;
        if (method != null) {
            method = method.trim();
        }
        String prevMethod = (String)this.getObjectList().get(row);
        if (method != null && method.length() > 0 && !method.equals(prevMethod) && !this.getCallbackDescriptor().getCallbackMethods().contains(method)) {
            this.getObjectList().set(row, method);
            this.getCallbackDescriptor().setCallbackMethodAt(row, method);
            this.fireTableRowsUpdated(row, row);
            this.mediator.fireCallbackMethodEvent(new CallbackMethodEvent(this.eventSource, prevMethod, method, 1));
        }
    }

    public CallbackDescriptor getCallbackDescriptor() {
        return this.callbackDescriptor;
    }

    public CallbackType getCallbackType() {
        return this.callbackType;
    }

    @Override
    public boolean isColumnSortable(int sortCol) {
        return false;
    }

    @Override
    public void sortByColumn(int sortCol, boolean isAscent) {
    }
}

