/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.dialog.objentity.ClassNameUpdaterView;
import org.apache.cayenne.modeler.util.CayenneController;

public class ClassNameUpdater
extends CayenneController {
    protected ClassNameUpdaterView view;
    protected ObjEntity entity;
    protected boolean updatePerformed;

    public ClassNameUpdater(CayenneController parent, ObjEntity entity) {
        super(parent);
        this.entity = entity;
    }

    public boolean doNameUpdate() {
        this.view = null;
        this.updatePerformed = false;
        boolean askForUpdate = true;
        String oldName = this.entity.getClassName();
        String suggestedName = this.suggestedClassName();
        if (oldName == null || oldName.length() == 0) {
            askForUpdate = false;
        } else if (suggestedName == null || suggestedName.equals(oldName)) {
            askForUpdate = false;
        } else if (oldName.contains("UntitledObjEntity")) {
            this.entity.setClassName(suggestedName);
            this.updatePerformed = true;
            askForUpdate = false;
        }
        if (askForUpdate) {
            this.view = new ClassNameUpdaterView();
            this.view.getClassName().setText("Update class name to " + suggestedName + " to match current entity name?");
            this.initBindings(suggestedName);
            this.view.pack();
            this.view.setModal(true);
            this.centerView();
            this.makeCloseableOnEscape();
            this.view.setVisible(true);
        }
        return this.updatePerformed;
    }

    private String suggestedClassName() {
        String pkg = this.entity.getDataMap() == null ? null : this.entity.getDataMap().getDefaultPackage();
        return ClassNameUpdater.suggestedClassName(this.entity.getName(), pkg, this.entity.getClassName());
    }

    private static String suggestedClassName(String entityName, String suggestedPackage, String oldClassName) {
        int lastDotIndex;
        if (entityName == null || entityName.trim().isEmpty()) {
            return null;
        }
        String pkg = suggestedPackage;
        if (oldClassName != null && oldClassName.lastIndexOf(46) > 0) {
            pkg = oldClassName.substring(0, oldClassName.lastIndexOf(46));
        }
        if ((lastDotIndex = entityName.lastIndexOf(46)) >= 0 && lastDotIndex < entityName.length() - 1) {
            entityName = entityName.substring(lastDotIndex + 1);
        }
        return DataMap.getNameWithPackage(pkg, entityName);
    }

    protected void initBindings(String suggestedName) {
        this.view.getUpdateButton().addActionListener(e -> {
            this.entity.setClassName(suggestedName);
            this.updatePerformed = true;
            this.view.dispose();
        });
        this.view.getCancelButton().addActionListener(e -> this.view.dispose());
    }

    @Override
    public Component getView() {
        return this.view;
    }
}

