/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action.dbimport;

import java.awt.event.ActionEvent;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;

public abstract class AddPatternParamAction
extends TreeManipulationAction {
    private Class paramClass;

    AddPatternParamAction(String name, Application application) {
        super(name, application);
    }

    private void addPatternParamToContainer(Class paramClass, Object selectedObject, String name, DbImportTreeNode node) {
        FilterContainer container = (FilterContainer)selectedObject;
        PatternParam element = null;
        if (paramClass == ExcludeTable.class) {
            element = new ExcludeTable(name);
            container.addExcludeTable((ExcludeTable)element);
        } else if (paramClass == IncludeColumn.class) {
            element = new IncludeColumn(name);
            container.addIncludeColumn((IncludeColumn)element);
        } else if (paramClass == ExcludeColumn.class) {
            element = new ExcludeColumn(name);
            container.addExcludeColumn((ExcludeColumn)element);
        } else if (paramClass == IncludeProcedure.class) {
            element = new IncludeProcedure(name);
            container.addIncludeProcedure((IncludeProcedure)element);
        } else if (paramClass == ExcludeProcedure.class) {
            element = new ExcludeProcedure(name);
            container.addExcludeProcedure((ExcludeProcedure)element);
        }
        node.add(new DbImportTreeNode(element));
    }

    private void addPatternParamToIncludeTable(Class paramClass, Object selectedObject, String name, DbImportTreeNode node) {
        IncludeTable includeTable = (IncludeTable)selectedObject;
        PatternParam element = null;
        if (paramClass == IncludeColumn.class) {
            element = new IncludeColumn(name);
            includeTable.addIncludeColumn((IncludeColumn)element);
        } else if (paramClass == ExcludeColumn.class) {
            element = new ExcludeColumn(name);
            includeTable.addExcludeColumn((ExcludeColumn)element);
        }
        node.add(new DbImportTreeNode(element));
    }

    @Override
    public void performAction(ActionEvent e) {
        ReverseEngineering reverseEngineeringOldCopy = this.prepareElements();
        if (this.reverseEngineeringIsEmpty()) {
            this.tree.getRootNode().removeAllChildren();
        }
        if (this.canBeInserted(this.selectedElement)) {
            Object selectedObject = this.selectedElement.getUserObject();
            if (selectedObject instanceof FilterContainer) {
                this.addPatternParamToContainer(this.paramClass, selectedObject, this.name, this.selectedElement);
            } else if (selectedObject instanceof IncludeTable) {
                this.addPatternParamToIncludeTable(this.paramClass, selectedObject, this.name, this.selectedElement);
            }
            this.updateSelected = true;
        } else {
            Object selectedObject;
            if (this.parentElement == null) {
                this.parentElement = this.tree.getRootNode();
            }
            if ((selectedObject = this.parentElement.getUserObject()) instanceof FilterContainer) {
                this.addPatternParamToContainer(this.paramClass, selectedObject, this.name, this.parentElement);
            } else if (selectedObject instanceof IncludeTable) {
                this.addPatternParamToIncludeTable(this.paramClass, selectedObject, this.name, this.parentElement);
            }
            this.updateSelected = false;
        }
        this.completeInserting(reverseEngineeringOldCopy);
    }

    public void setParamClass(Class paramClass) {
        this.paramClass = paramClass;
    }
}

