/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportNodeHandler;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTreeCellRenderer;

public class ColorTreeRenderer
extends DbImportTreeCellRenderer {
    private DbImportNodeHandler handler = new DbImportNodeHandler();
    private DbImportTree reverseEngineeringTree;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DbImportTree renderedTree = (DbImportTree)tree;
        this.handler.setDbSchemaNode(this.node);
        if (this.node.isLabel()) {
            this.setForeground(DbImportNodeHandler.LABEL_COLOR);
            return this;
        }
        if (this.handler.isContainer(this.node) || this.handler.isFirstNodeIsPrimitive(renderedTree)) {
            this.handler.setHasEntitiesInEmptyContainer(false);
        }
        if (this.selected) {
            this.setForeground(Color.BLACK);
            this.node.setColorized(this.node.isColorized());
            return this;
        }
        this.handler.findFirstLevelIncludeTable();
        if (!this.handler.checkTreesLevels(renderedTree)) {
            this.setForeground(DbImportNodeHandler.NON_INCLUDE_COLOR);
            this.node.setColorized(false);
            return this;
        }
        DbImportTreeNode root = this.reverseEngineeringTree.getSelectionPath() != null ? this.reverseEngineeringTree.getSelectedNode() : this.reverseEngineeringTree.getRootNode();
        renderedTree.getRootNode().setColorized(true);
        int traverseResult = this.handler.traverseTree(root);
        if (traverseResult > 0) {
            if (root.getUserObject().getClass() == IncludeColumn.class) {
                if (this.handler.nodesIsEqual(root)) {
                    this.setForeground(this.handler.getColorByNodeType(root));
                    this.node.setColorized(true);
                    return this;
                }
                this.setForeground(DbImportNodeHandler.NON_INCLUDE_COLOR);
                this.node.setColorized(false);
                return this;
            }
            if (root.getUserObject().getClass() == IncludeProcedure.class) {
                if (this.handler.nodesIsEqual(root)) {
                    this.setForeground(this.handler.getColorByNodeType(root));
                    this.node.setColorized(true);
                    return this;
                }
                this.setForeground(DbImportNodeHandler.NON_INCLUDE_COLOR);
                this.node.setColorized(false);
                return this;
            }
            if (!this.handler.isExistCatalogsOrSchemas()) {
                if (root.isExcludeTable() || root.isExcludeProcedure() || root.isExcludeColumn()) {
                    if (this.handler.nodesIsEqual(root)) {
                        this.setForeground(this.handler.getColorByNodeType(root));
                        this.node.setColorized(true);
                        return this;
                    }
                    this.setForeground(DbImportNodeHandler.NON_INCLUDE_COLOR);
                    this.node.setColorized(false);
                    return this;
                }
                if (root.equals(this.node)) {
                    this.setForeground(this.handler.getColorByNodeType(root));
                    this.node.setColorized(true);
                    return this;
                }
            }
            if (this.handler.isParentIncluded()) {
                this.setForeground(this.handler.getColorByNodeType(root));
                this.node.setColorized(true);
                return this;
            }
        } else {
            this.setForeground(DbImportNodeHandler.NON_INCLUDE_COLOR);
            this.node.setColorized(false);
            return this;
        }
        if (this.handler.isParentIncluded() || this.reverseEngineeringTree.getSelectionPath() != null) {
            this.setForeground(this.handler.getColorByNodeType(root));
            this.node.setColorized(true);
            return this;
        }
        if (!this.handler.isExistCatalogsOrSchemas()) {
            this.setForeground(this.handler.getColorByNodeType(root));
            this.node.setColorized(true);
            return this;
        }
        this.setForeground(DbImportNodeHandler.NON_INCLUDE_COLOR);
        this.node.setColorized(false);
        return this;
    }

    public void setReverseEngineeringTree(DbImportTree reverseEngineeringTree) {
        this.reverseEngineeringTree = reverseEngineeringTree;
        this.handler.setReverseEngineeringTree(reverseEngineeringTree);
    }
}

