/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.naming;

import java.util.Objects;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.dbsync.naming.CallbackNameBuilder;
import org.apache.cayenne.dbsync.naming.DeduplicationVisitor;
import org.apache.cayenne.dbsync.naming.DefaultBaseNameVisitor;
import org.apache.cayenne.dbsync.naming.NormalizationVisitor;
import org.apache.cayenne.map.ObjEntity;

public class NameBuilder {
    protected ConfigurationNode nodeToName;
    protected ConfigurationNode parent;
    protected String dupesPattern;
    protected String baseName;

    protected NameBuilder(ConfigurationNode nodeToName) {
        this.nodeToName = Objects.requireNonNull(nodeToName);
        this.dupesPattern = "%s%d";
    }

    public static NameBuilder builder(ConfigurationNode node) {
        return new NameBuilder(node);
    }

    public static NameBuilder builder(ConfigurationNode node, ConfigurationNode parent) {
        return new NameBuilder(node).in(parent);
    }

    public static NameBuilder builderForCallbackMethod(ObjEntity parent) {
        return new CallbackNameBuilder().in(parent);
    }

    public NameBuilder in(ConfigurationNode parent) {
        this.parent = Objects.requireNonNull(parent);
        return this;
    }

    public NameBuilder dupesPattern(String dupesPattern) {
        this.dupesPattern = Objects.requireNonNull(dupesPattern);
        return this;
    }

    public NameBuilder baseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    public String name() {
        String baseName = this.baseName != null && this.baseName.length() > 0 ? this.baseName : this.nodeToName.acceptVisitor(DefaultBaseNameVisitor.INSTANCE);
        String normalizedBaseName = this.nodeToName.acceptVisitor(new NormalizationVisitor(baseName));
        return this.nodeToName.acceptVisitor(new DeduplicationVisitor(this.parent, normalizedBaseName, this.dupesPattern));
    }
}

