/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.tree;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.tree.JGraphAbstractTreeLayout;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JGraphTreeLayout
extends JGraphAbstractTreeLayout {
    protected int alignment = 1;
    protected boolean combineLevelNodes = true;

    public void run(JGraphFacade jGraphFacade) {
        super.run(jGraphFacade);
        for (int i = 0; i < jGraphFacade.getRootCount(); ++i) {
            this.nodes.clear();
            jGraphFacade.dfs(jGraphFacade.getRootAt(i), new JGraphFacade.CellVisitor(){

                public void visit(Object object, Object object2, Object object3, int n, int n2) {
                    StandardTreeNode standardTreeNode = JGraphTreeLayout.this.getTreeNode(object);
                    StandardTreeNode standardTreeNode2 = JGraphTreeLayout.this.getTreeNode(object2);
                    if (standardTreeNode != null) {
                        standardTreeNode.addChild(standardTreeNode2);
                        standardTreeNode2.setParent(standardTreeNode);
                    }
                }
            });
            StandardTreeNode standardTreeNode = this.getTreeNode(jGraphFacade.getRootAt(i));
            this.layout(standardTreeNode);
            if (this.combineLevelNodes) {
                this.setLevelHeights(standardTreeNode);
            }
            if (this.positionMultipleTrees) {
                this.spaceMultipleTrees(standardTreeNode);
            }
            standardTreeNode.setPosition(null, 0.0);
        }
    }

    protected StandardTreeNode getTreeNode(Object object) {
        if (object != null) {
            StandardTreeNode standardTreeNode = (StandardTreeNode)this.nodes.get(object);
            if (standardTreeNode == null) {
                standardTreeNode = new StandardTreeNode(object);
                this.nodes.put(object, standardTreeNode);
            }
            return standardTreeNode;
        }
        return null;
    }

    protected void layout(StandardTreeNode standardTreeNode) {
        if (standardTreeNode.children.size() != 0) {
            if (standardTreeNode.children.size() == 1) {
                StandardTreeNode standardTreeNode2 = (StandardTreeNode)standardTreeNode.children.get(0);
                standardTreeNode2.setDepth(standardTreeNode.getDepth() + 1);
                this.layout(standardTreeNode2);
                standardTreeNode2.leftContour.dx = (standardTreeNode2.width - standardTreeNode.width) / 2.0;
                standardTreeNode2.rightContour.dx = (standardTreeNode2.width - standardTreeNode.width) / 2.0;
                standardTreeNode.leftContour.next = standardTreeNode2.leftContour;
                standardTreeNode.rightContour.next = standardTreeNode2.rightContour;
            } else {
                Iterator iterator = standardTreeNode.children.iterator();
                while (iterator.hasNext()) {
                    StandardTreeNode standardTreeNode3 = (StandardTreeNode)iterator.next();
                    standardTreeNode3.setDepth(standardTreeNode.getDepth() + 1);
                    this.layout(standardTreeNode3);
                }
                this.join(standardTreeNode);
            }
        }
    }

    protected void join(StandardTreeNode standardTreeNode) {
        StandardTreeNode standardTreeNode2;
        int n;
        StandardTreeNode standardTreeNode3;
        int n2;
        Object object;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < standardTreeNode.children.size(); ++n3) {
            object = (StandardTreeNode)standardTreeNode.children.get(n3);
            for (n2 = n3 + 1; n2 < standardTreeNode.children.size(); ++n2) {
                standardTreeNode3 = (StandardTreeNode)standardTreeNode.children.get(n2);
                n = this.distance(((StandardTreeNode)object).rightContour, standardTreeNode3.leftContour) / (n2 - n3);
                n4 = Math.max(n4, n);
            }
        }
        n4 = (int)((double)n4 + this.nodeDistance);
        n3 = standardTreeNode.children.size() % 2 == 0 ? (standardTreeNode.children.size() / 2 - 1) * n4 + n4 / 2 : standardTreeNode.children.size() / 2 * n4;
        object = standardTreeNode.children.iterator();
        n2 = 0;
        while (object.hasNext()) {
            ((StandardTreeNode)object.next()).x = -n3 + n2 * n4;
            ++n2;
        }
        StandardTreeNode standardTreeNode4 = this.getLeftMostX(standardTreeNode);
        standardTreeNode3 = this.getRightMostX(standardTreeNode);
        standardTreeNode.leftContour.next = standardTreeNode4.leftContour;
        standardTreeNode.rightContour.next = standardTreeNode3.rightContour;
        for (n = 1; n < standardTreeNode.children.size(); ++n) {
            standardTreeNode2 = (StandardTreeNode)standardTreeNode.children.get(n);
            this.merge(standardTreeNode.leftContour.next, standardTreeNode2.leftContour, (double)(n * n4) + standardTreeNode.width);
        }
        for (n = standardTreeNode.children.size() - 2; n >= 0; --n) {
            standardTreeNode2 = (StandardTreeNode)standardTreeNode.children.get(n);
            this.merge(standardTreeNode.rightContour.next, standardTreeNode2.rightContour, (double)(n * n4) + standardTreeNode.width);
        }
        n4 = (standardTreeNode.children.size() - 1) * n4 / 2;
        standardTreeNode.leftContour.next.dx += (double)n4 - standardTreeNode.width / 2.0;
        standardTreeNode.rightContour.next.dx += (double)n4 - standardTreeNode.width / 2.0;
    }

    protected StandardTreeNode getLeftMostX(StandardTreeNode standardTreeNode) {
        double d = Double.MAX_VALUE;
        boolean bl = false;
        StandardTreeNode standardTreeNode2 = null;
        Iterator iterator = standardTreeNode.getChildren();
        while (iterator.hasNext()) {
            StandardTreeNode standardTreeNode3 = (StandardTreeNode)iterator.next();
            double d2 = standardTreeNode3.x - (double)standardTreeNode3.getLeftWidth();
            if (d2 < d) {
                standardTreeNode2 = standardTreeNode3;
                d = d2;
            }
            bl = true;
        }
        if (standardTreeNode2 != null) {
            return standardTreeNode2;
        }
        return bl ? (StandardTreeNode)standardTreeNode.children.get(0) : standardTreeNode;
    }

    protected StandardTreeNode getRightMostX(StandardTreeNode standardTreeNode) {
        double d = Double.MIN_VALUE;
        boolean bl = false;
        StandardTreeNode standardTreeNode2 = null;
        Iterator iterator = standardTreeNode.getChildren();
        while (iterator.hasNext()) {
            StandardTreeNode standardTreeNode3 = (StandardTreeNode)iterator.next();
            double d2 = standardTreeNode3.x + (double)standardTreeNode3.getRightWidth();
            if (d2 > d) {
                standardTreeNode2 = standardTreeNode3;
                d = d2;
            }
            bl = true;
        }
        if (standardTreeNode2 != null) {
            return standardTreeNode2;
        }
        return bl ? (StandardTreeNode)standardTreeNode.children.get(0) : standardTreeNode;
    }

    protected void merge(PolyLine polyLine, PolyLine polyLine2, double d) {
        while (polyLine != null) {
            if (polyLine2.next == null) {
                return;
            }
            if (polyLine.next == null) {
                polyLine2 = polyLine2.next;
                break;
            }
            d += polyLine.dx - polyLine2.dx;
            polyLine = polyLine.next;
            polyLine2 = polyLine2.next;
        }
        polyLine2.dx += -d;
        polyLine.next = polyLine2;
    }

    protected int distance(PolyLine polyLine, PolyLine polyLine2) {
        int n = 0;
        int n2 = 0;
        while (polyLine != null && polyLine2 != null) {
            if ((n2 = (int)((double)n2 + (polyLine.dx + polyLine2.dx))) > 0) {
                n += n2;
                n2 = 0;
            }
            polyLine = polyLine.next;
            polyLine2 = polyLine2.next;
        }
        return n;
    }

    protected void setPosition(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((StandardTreeNode)iterator.next()).setPosition(null, 0.0);
        }
    }

    protected void setLevelHeights(StandardTreeNode standardTreeNode) {
        List list = standardTreeNode.getNodesByLevel();
        double d = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            int n;
            List list2 = (List)list.get(i);
            for (n = 0; n < list2.size(); ++n) {
                d = Math.max(d, ((StandardTreeNode)list2.get((int)n)).height);
            }
            for (n = 0; n < list2.size(); ++n) {
                ((StandardTreeNode)list2.get((int)n)).levelheight = d;
            }
            d = 0.0;
        }
    }

    protected void spaceMultipleTrees(StandardTreeNode standardTreeNode) {
        int n;
        double d;
        int n2;
        Point2D point2D = this.graph.getLocation(standardTreeNode.cell);
        double d2 = 0.0;
        double d3 = 0.0;
        if (point2D != null) {
            d2 = this.graph.getLocation(standardTreeNode.cell).getX();
            d3 = this.graph.getLocation(standardTreeNode.cell).getY();
        }
        if (this.orientation == 1) {
            n2 = standardTreeNode.getLeftWidth();
            d = d2 - (double)n2;
            if (d < this.treeBoundary + this.treeDistance) {
                d2 = this.treeBoundary + this.treeDistance + (double)n2;
                this.graph.setLocation(standardTreeNode.cell, d2, d3);
            }
            n = standardTreeNode.getRightWidth();
            this.treeBoundary = d2 + (double)n;
        }
        if (this.orientation == 5) {
            n2 = standardTreeNode.getRightWidth();
            d = d2 - (double)n2;
            if (d < this.treeBoundary + this.treeDistance) {
                d2 = this.treeBoundary + this.treeDistance + (double)n2;
                this.graph.setLocation(standardTreeNode.cell, d2, d3);
            }
            n = standardTreeNode.getLeftWidth();
            this.treeBoundary = d2 + (double)n;
        }
        if (this.orientation == 7) {
            n2 = standardTreeNode.getLeftWidth();
            d = d3 - (double)n2;
            if (d < this.treeBoundary + this.treeDistance) {
                d3 = this.treeBoundary + this.treeDistance + (double)n2;
                this.graph.setLocation(standardTreeNode.cell, d2, d3);
            }
            n = standardTreeNode.getRightWidth();
            this.treeBoundary = d3 + (double)n;
        }
        if (this.orientation == 3) {
            n2 = standardTreeNode.getRightWidth();
            d = d3 - (double)n2;
            if (d < this.treeBoundary + this.treeDistance) {
                d3 = this.treeBoundary + this.treeDistance + (double)n2;
                this.graph.setLocation(standardTreeNode.cell, d2, d3);
            }
            n = standardTreeNode.getLeftWidth();
            this.treeBoundary = d3 + (double)n + this.getRightMostX((StandardTreeNode)standardTreeNode).height;
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        if (n != 1 && n != 0 && n != 3) {
            throw new IllegalArgumentException("Alignment must be one of TOP, CENTER or BOTTOM");
        }
        this.alignment = n;
    }

    public boolean isCombineLevelNodes() {
        return this.combineLevelNodes;
    }

    public void setCombineLevelNodes(boolean bl) {
        this.combineLevelNodes = bl;
    }

    public String toString() {
        return "Tree";
    }

    protected class PolyLine {
        double dx;
        PolyLine next;

        public PolyLine(double d) {
            this.dx = d;
        }
    }

    protected class StandardTreeNode
    extends JGraphAbstractTreeLayout.TreeNode {
        List children = new ArrayList();
        double levelheight;
        PolyLine leftContour;
        PolyLine rightContour;
        private int depth;
        protected JGraphAbstractTreeLayout.TreeNode parent;

        public StandardTreeNode(Object object) {
            super(object);
            this.leftContour = new PolyLine(this.width / 2.0);
            this.rightContour = new PolyLine(this.width / 2.0);
            this.depth = 0;
        }

        public Iterator getChildren() {
            return this.children.iterator();
        }

        public int getLeftWidth() {
            int n = 0;
            PolyLine polyLine = this.leftContour;
            int n2 = 0;
            while (polyLine != null) {
                if ((n2 = (int)((double)n2 + polyLine.dx)) > 0) {
                    n += n2;
                    n2 = 0;
                }
                polyLine = polyLine.next;
            }
            return n;
        }

        public int getRightWidth() {
            int n = 0;
            PolyLine polyLine = this.rightContour;
            int n2 = 0;
            while (polyLine != null) {
                if ((n2 = (int)((double)n2 + polyLine.dx)) > 0) {
                    n += n2;
                    n2 = 0;
                }
                polyLine = polyLine.next;
            }
            return n;
        }

        public double getHeight() {
            if (this.children.isEmpty()) {
                return this.levelheight;
            }
            double d = 0.0;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                d = Math.max(d, ((StandardTreeNode)iterator.next()).getHeight());
            }
            return d + JGraphTreeLayout.this.levelDistance + this.levelheight;
        }

        public void addChild(StandardTreeNode standardTreeNode) {
            this.children.add(standardTreeNode);
        }

        public void setPosition(Point2D point2D, double d) {
            double d2 = 0.0;
            Object object = this.children.iterator();
            while (object.hasNext()) {
                d2 = Math.max(d2, ((StandardTreeNode)object.next()).height);
            }
            object = JGraphTreeLayout.this.graph.getLocation(this.cell);
            if (object == null) {
                object = new Point2D.Double(0.0, 0.0);
            }
            if (point2D == null) {
                if (JGraphTreeLayout.this.orientation == 7 || JGraphTreeLayout.this.orientation == 3) {
                    ((Point2D)object).setLocation(((Point2D)object).getY(), ((Point2D)object).getX());
                }
                if (JGraphTreeLayout.this.orientation == 1 || JGraphTreeLayout.this.orientation == 7) {
                    point2D = new Point2D.Double(((Point2D)object).getX() + this.width / 2.0, ((Point2D)object).getY() + this.height);
                } else if (JGraphTreeLayout.this.orientation == 5 || JGraphTreeLayout.this.orientation == 3) {
                    point2D = new Point2D.Double(((Point2D)object).getX() + this.width / 2.0, ((Point2D)object).getY());
                }
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((StandardTreeNode)iterator.next()).setPosition(point2D, d2);
                }
                return;
            }
            if (JGraphTreeLayout.this.combineLevelNodes) {
                d = this.levelheight;
            }
            object = new Point2D.Double(this.width, this.height);
            if (JGraphTreeLayout.this.orientation == 1 || JGraphTreeLayout.this.orientation == 7) {
                ((Point2D)object).setLocation(this.x + point2D.getX() - this.width / 2.0, point2D.getY() + JGraphTreeLayout.this.levelDistance);
            } else {
                ((Point2D)object).setLocation(this.x + point2D.getX() - this.width / 2.0, point2D.getY() - JGraphTreeLayout.this.levelDistance - this.levelheight);
            }
            if (JGraphTreeLayout.this.alignment == 0) {
                ((Point2D)object).setLocation(((Point2D)object).getX(), ((Point2D)object).getY() + (d - this.height) / 2.0);
            } else if (JGraphTreeLayout.this.alignment == 3) {
                ((Point2D)object).setLocation(((Point2D)object).getX(), ((Point2D)object).getY() + d - this.height);
            }
            if (JGraphTreeLayout.this.orientation == 7 || JGraphTreeLayout.this.orientation == 3) {
                ((Point2D)object).setLocation(((Point2D)object).getY(), ((Point2D)object).getX());
            }
            JGraphTreeLayout.this.graph.setLocation(this.cell, ((Point2D)object).getX(), ((Point2D)object).getY());
            this.y = JGraphTreeLayout.this.orientation == 1 || JGraphTreeLayout.this.orientation == 7 ? (double)((int)(point2D.getY() + JGraphTreeLayout.this.levelDistance + d)) : (double)((int)(point2D.getY() - JGraphTreeLayout.this.levelDistance - d));
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((StandardTreeNode)iterator.next()).setPosition(new Point2D.Double(this.x + point2D.getX(), this.y), d2);
            }
            if (JGraphTreeLayout.this.routeTreeEdges) {
                this.routeEdges(point2D);
            }
        }

        public List getNodesByLevel() {
            ArrayList arrayList = new ArrayList<Object>();
            Object object = this.children.iterator();
            while (object.hasNext()) {
                ArrayList<Object> arrayList2 = ((StandardTreeNode)object.next()).getNodesByLevel();
                if (arrayList.size() < arrayList2.size()) {
                    ArrayList<Object> arrayList3 = arrayList;
                    arrayList = arrayList2;
                    arrayList2 = arrayList3;
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ((List)arrayList.get(i)).addAll((List)arrayList2.get(i));
                }
            }
            object = new ArrayList();
            ((ArrayList)object).add(this);
            arrayList.add(0, object);
            return arrayList;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int n) {
            this.depth = n;
        }

        public JGraphAbstractTreeLayout.TreeNode getParent() {
            return this.parent;
        }

        public void setParent(JGraphAbstractTreeLayout.TreeNode treeNode) {
            this.parent = treeNode;
        }
    }
}

