/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EJBQLQueryDescriptor;
import org.apache.cayenne.map.ProcedureQueryDescriptor;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.map.SelectQueryDescriptor;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.util.XMLSerializable;

public class QueryDescriptorLoader {
    protected String name;
    protected String queryType;
    protected String sql;
    protected String ejbql;
    protected Expression qualifier;
    protected DataMap dataMap;
    protected String rootType;
    protected String rootName;
    protected String resultEntity;
    protected List<Ordering> orderings = new ArrayList<Ordering>();
    protected List<String> prefetches = new ArrayList<String>();
    protected Map<String, String> adapterSql = new HashMap<String, String>();
    protected Map<String, String> properties = new HashMap<String, String>();

    public QueryDescriptor buildQueryDescriptor() {
        QueryDescriptor descriptor = QueryDescriptor.descriptor(this.queryType);
        descriptor.setName(this.name);
        descriptor.setDataMap(this.dataMap);
        descriptor.setRoot(this.getRoot());
        descriptor.setProperties(this.properties);
        switch (this.queryType) {
            case "SelectQuery": {
                ((SelectQueryDescriptor)descriptor).setQualifier(this.qualifier);
                ((SelectQueryDescriptor)descriptor).setOrderings(this.orderings);
                ((SelectQueryDescriptor)descriptor).setPrefetches(this.prefetches);
                break;
            }
            case "SQLTemplate": {
                ((SQLTemplateDescriptor)descriptor).setSql(this.sql);
                ((SQLTemplateDescriptor)descriptor).setAdapterSql(this.adapterSql);
                break;
            }
            case "EJBQLQuery": {
                ((EJBQLQueryDescriptor)descriptor).setEjbql(this.ejbql);
                break;
            }
            case "ProcedureQuery": {
                ((ProcedureQueryDescriptor)descriptor).setResultEntityName(this.resultEntity);
                break;
            }
        }
        return descriptor;
    }

    void setName(String name) {
        this.name = name;
    }

    void setLegacyFactory(String factory) {
        switch (factory) {
            case "org.apache.cayenne.map.SelectQueryBuilder": {
                this.queryType = "SelectQuery";
                break;
            }
            case "org.apache.cayenne.map.SQLTemplateBuilder": {
                this.queryType = "SQLTemplate";
                break;
            }
            case "org.apache.cayenne.map.EjbqlBuilder": {
                this.queryType = "EJBQLQuery";
                break;
            }
            case "org.apache.cayenne.map.ProcedureQueryBuilder": {
                this.queryType = "ProcedureQuery";
                break;
            }
            default: {
                throw new ConfigurationException("Unknown query factory: " + factory, new Object[0]);
            }
        }
    }

    void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    protected Object getRoot() {
        XMLSerializable root = null;
        if (this.rootType == null || "data-map".equals(this.rootType) || this.rootName == null) {
            root = this.dataMap;
        } else if ("obj-entity".equals(this.rootType)) {
            root = this.dataMap.getObjEntity(this.rootName);
        } else if ("db-entity".equals(this.rootType)) {
            root = this.dataMap.getDbEntity(this.rootName);
        } else if ("procedure".equals(this.rootType)) {
            root = this.dataMap.getProcedure(this.rootName);
        } else if ("java-class".equals(this.rootType)) {
            root = this.dataMap.getObjEntityForJavaClass(this.rootName);
        }
        return root != null ? root : this.dataMap;
    }

    void setResultEntity(String resultEntity) {
        this.resultEntity = resultEntity;
    }

    void setRoot(DataMap dataMap, String rootType, String rootName) {
        this.dataMap = dataMap;
        this.rootType = rootType;
        this.rootName = rootName;
    }

    void setEjbql(String ejbql) {
        this.ejbql = ejbql;
    }

    void addSql(String sql, String adapterClass) {
        if (adapterClass == null) {
            this.sql = sql;
        } else {
            if (this.adapterSql == null) {
                this.adapterSql = new HashMap<String, String>();
            }
            this.adapterSql.put(adapterClass, sql);
        }
    }

    void setQualifier(String qualifier) {
        this.qualifier = qualifier == null || qualifier.trim().length() == 0 ? null : ExpressionFactory.exp(qualifier.trim(), new Object[0]);
    }

    void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    void addOrdering(String path, String descending, String ignoreCase) {
        if (this.orderings == null) {
            this.orderings = new ArrayList<Ordering>();
        }
        if (path != null && path.trim().length() == 0) {
            path = null;
        }
        boolean isDescending = "true".equalsIgnoreCase(descending);
        boolean isIgnoringCase = "true".equalsIgnoreCase(ignoreCase);
        SortOrder order = isDescending ? (isIgnoringCase ? SortOrder.DESCENDING_INSENSITIVE : SortOrder.DESCENDING) : (isIgnoringCase ? SortOrder.ASCENDING_INSENSITIVE : SortOrder.ASCENDING);
        this.orderings.add(new Ordering(path, order));
    }

    void addPrefetch(String path) {
        if (path == null || path != null && path.trim().length() == 0) {
            return;
        }
        if (this.prefetches == null) {
            this.prefetches = new ArrayList<String>();
        }
        this.prefetches.add(path.trim());
    }
}

