/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class FilteredIconFactory {
    private static final JComponent DUMMY = new JPanel();

    public static Icon createDisabledIcon(Icon icon) {
        return FilteredIconFactory.createIcon(icon, FilterType.DISABLE);
    }

    public static Icon createIcon(Icon icon, FilterType filterType) {
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconWidth(), 2);
            icon.paintIcon(DUMMY, img.getGraphics(), 0, 0);
            FilteredImageSource producer = new FilteredImageSource(img.getSource(), filterType.filter);
            Image resultImage = DUMMY.createImage(producer);
            return new ImageIcon(resultImage);
        }
        return null;
    }

    static class DisabledFilter
    extends RGBImageFilter {
        private static final double COLOR_FACTOR = 0.4;
        private static final double ALPHA_FACTOR = 0.5;

        DisabledFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            int luminance = (int)(0.6 * Math.min(255.0, (double)(r + g + b) / 3.0));
            return (int)((double)a * 0.5) << 24 | (int)((double)r * 0.4 + (double)luminance) << 16 | (int)((double)g * 0.4 + (double)luminance) << 8 | (int)((double)b * 0.4 + (double)luminance);
        }
    }

    static class SelectionFilter
    extends ColorFilter {
        SelectionFilter() {
            super(UIManager.getColor("Tree.selectionForeground").getRGB() & 0xFFFFFF);
        }
    }

    static class ColorFilter
    extends RGBImageFilter {
        private final int color;

        ColorFilter(int color) {
            this.canFilterIndexColorModel = true;
            this.color = color;
        }

        @Override
        public int filterRGB(int x, int y, int argb) {
            int alpha = argb >> 24 & 0xFF;
            return alpha << 24 | this.color;
        }
    }

    public static enum FilterType {
        DISABLE(new DisabledFilter()),
        SELECTION(new SelectionFilter()),
        WHITE(new ColorFilter(0xFFFFFF)),
        GREEN(new ColorFilter(6662427)),
        VIOLET(new ColorFilter(11368669)),
        BLUE(new ColorFilter(5481430)),
        GRAY(new ColorFilter(0x434343));

        private final RGBImageFilter filter;

        private FilterType(RGBImageFilter filter) {
            this.filter = filter;
        }
    }
}

