/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.DefaultQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryMetadataWrapper;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;

public class QueryChain
implements Query {
    protected Collection<Query> chain;
    @Deprecated
    protected String name;
    @Deprecated
    protected DataMap dataMap;

    public QueryChain() {
    }

    public QueryChain(Query[] queries) {
        if (queries != null && queries.length > 0) {
            this.chain = new ArrayList<Query>(Arrays.asList(queries));
        }
    }

    public QueryChain(Collection<? extends Query> queries) {
        if (queries != null && !queries.isEmpty()) {
            this.chain = new ArrayList<Query>(queries);
        }
    }

    public void addQuery(Query query) {
        if (this.chain == null) {
            this.chain = new ArrayList<Query>();
        }
        this.chain.add(query);
    }

    public boolean removeQuery(Query query) {
        return this.chain != null && this.chain.remove(query);
    }

    public boolean isEmpty() {
        return this.chain == null || this.chain.isEmpty();
    }

    @Override
    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        if (this.chain != null && !this.chain.isEmpty()) {
            for (Query q : this.chain) {
                q.route(router, resolver, substitutedQuery);
            }
        }
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        throw new CayenneRuntimeException("Chain doesn't support its own execution and should've been split into separate queries during routing phase.", new Object[0]);
    }

    @Override
    @Deprecated
    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Deprecated
    public DataMap getDataMap() {
        return this.dataMap;
    }

    @Deprecated
    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        QueryMetadataWrapper wrapper = new QueryMetadataWrapper(DefaultQueryMetadata.defaultMetadata);
        wrapper.override("cayenne.GenericSelectQuery.fetchingDataRows", Boolean.TRUE);
        return wrapper;
    }
}

