/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.pref.CayennePreference;
import org.apache.cayenne.pref.PreferenceDecorator;

public class ChildrenMapPreference
extends PreferenceDecorator {
    private Map<String, Object> children;
    private List<String> removeObject;

    public ChildrenMapPreference(CayennePreference delegate) {
        super(delegate);
        this.children = new HashMap<String, Object>();
        this.removeObject = new ArrayList<String>();
    }

    public ChildrenMapPreference(CayennePreference delegate, Preferences preferences) {
        super(delegate);
        delegate.setCurrentPreference(preferences);
        this.children = new HashMap<String, Object>();
    }

    public void initChildrenPreferences() {
        HashMap children = new HashMap();
        try {
            String[] names;
            for (String name : names = this.getCurrentPreference().childrenNames()) {
                try {
                    Object newInstance = this.delegate.getClass().getConstructor(String.class, Boolean.TYPE).newInstance(name, true);
                    children.put(name, newInstance);
                }
                catch (Throwable e) {
                    throw new CayenneRuntimeException("Error initializing preference", e, new Object[0]);
                }
            }
            this.children.putAll(children);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public Map getChildrenPreferences() {
        return this.children;
    }

    public CayennePreference getObject(String key) {
        return (CayennePreference)this.children.get(key);
    }

    public void remove(String key) {
        this.removeObject.add(key);
        this.children.remove(key);
    }

    public CayennePreference create(String nodeName) {
        try {
            Object newInstance = this.delegate.getClass().getConstructor(String.class, Boolean.TYPE).newInstance(nodeName, false);
            this.children.put(nodeName, newInstance);
        }
        catch (Throwable e) {
            throw new CayenneRuntimeException("Error creating preference", new Object[0]);
        }
        return (CayennePreference)this.children.get(nodeName);
    }

    public void create(String nodeName, Object obj) {
        this.children.put(nodeName, obj);
    }

    public void save() {
        if (this.removeObject.size() > 0) {
            for (String string : this.removeObject) {
                try {
                    this.delegate.getCurrentPreference().node(string).removeNode();
                }
                catch (BackingStoreException e) {
                    throw new CayenneRuntimeException("Error saving preference", new Object[0]);
                }
            }
        }
        for (Map.Entry entry : this.children.entrySet()) {
            this.delegate.getCurrentPreference().node((String)entry.getKey());
            ((CayennePreference)entry.getValue()).saveObjectPreference();
        }
    }

    public void cancel() {
        this.children.clear();
        this.initChildrenPreferences();
    }
}

