/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.RawQueryPropertiesPanel;
import org.apache.cayenne.modeler.editor.SelectPropertiesPanel;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class SQLTemplateMainTab
extends JPanel {
    private static final String DEFAULT_CAPS_LABEL = "Database Default";
    private static final String LOWER_CAPS_LABEL = "Force Lower Case";
    private static final String UPPER_CAPS_LABEL = "Force Upper Case";
    private static final CapsStrategy[] LABEL_CAPITALIZATION = new CapsStrategy[]{CapsStrategy.DEFAULT, CapsStrategy.LOWER, CapsStrategy.UPPER};
    private static final Map<CapsStrategy, String> labelCapsLabels = new HashMap<CapsStrategy, String>();
    protected ProjectController mediator;
    protected TextAdapter name;
    protected SelectPropertiesPanel properties;

    public SQLTemplateMainTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                SQLTemplateMainTab.this.setQueryName(text);
            }
        };
        this.properties = new SQLTemplateQueryPropertiesPanel(this.mediator);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:max(80dlu;pref), 3dlu, fill:max(200dlu;pref)", "p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("SQLTemplate Settings", cc.xywh(1, 1, 3, 1));
        builder.addLabel("Query Name:", cc.xy(1, 3));
        builder.add((Component)this.name.getComponent(), cc.xy(3, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.properties, "Center");
    }

    void initFromModel() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        if (query == null || !"SQLTemplate".equals(query.getType())) {
            this.setVisible(false);
            return;
        }
        this.name.setText(query.getName());
        this.properties.initFromModel(query);
        this.setVisible(true);
    }

    protected QueryDescriptor getQuery() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        return query != null && "SQLTemplate".equals(query.getType()) ? query : null;
    }

    void setQueryName(String newName) {
        QueryDescriptor query;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((query = this.getQuery()) == null) {
            return;
        }
        if (Util.nullSafeEquals(newName, query.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Query name is required.", new Object[0]);
        }
        DataMap map = this.mediator.getCurrentDataMap();
        if (map.getQueryDescriptor(newName) != null) {
            throw new ValidationException("There is another query named '" + newName + "'. Use a different name.", new Object[0]);
        }
        QueryEvent e = new QueryEvent((Object)this, query, query.getName());
        ProjectUtil.setQueryName(map, query, newName);
        this.mediator.fireQueryEvent(e);
    }

    ObjEntity getEntity(QueryDescriptor query) {
        return query != null && query.getRoot() instanceof ObjEntity ? (ObjEntity)query.getRoot() : null;
    }

    void setEntity(ObjEntity entity) {
        QueryDescriptor template = this.getQuery();
        if (template != null) {
            ObjEntity root = entity != null ? entity : this.mediator.getCurrentDataMap();
            template.setRoot(root);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, template));
        }
    }

    static {
        labelCapsLabels.put(CapsStrategy.DEFAULT, DEFAULT_CAPS_LABEL);
        labelCapsLabels.put(CapsStrategy.LOWER, LOWER_CAPS_LABEL);
        labelCapsLabels.put(CapsStrategy.UPPER, UPPER_CAPS_LABEL);
    }

    final class SQLTemplateQueryPropertiesPanel
    extends RawQueryPropertiesPanel {
        private JComboBox labelCase;

        SQLTemplateQueryPropertiesPanel(ProjectController mediator) {
            super(mediator);
        }

        @Override
        protected PanelBuilder createPanelBuilder() {
            RowSpec[] extraRows;
            this.labelCase = Application.getWidgetFactory().createUndoableComboBox();
            this.labelCase.setRenderer(new LabelCapsRenderer());
            this.labelCase.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CapsStrategy value = (CapsStrategy)((Object)SQLTemplateQueryPropertiesPanel.this.labelCase.getModel().getSelectedItem());
                    SQLTemplateQueryPropertiesPanel.this.setQueryProperty("cayenne.SQLTemplate.columnNameCapitalization", value.name());
                }
            });
            PanelBuilder builder = super.createPanelBuilder();
            for (RowSpec extraRow : extraRows = RowSpec.decodeSpecs("3dlu, p")) {
                builder.appendRow(extraRow);
            }
            CellConstraints cc = new CellConstraints();
            builder.addLabel("Row Label Case:", cc.xy(1, 17));
            builder.add((Component)this.labelCase, cc.xywh(3, 17, 5, 1));
            return builder;
        }

        @Override
        public void initFromModel(QueryDescriptor query) {
            super.initFromModel(query);
            if (query != null && "SQLTemplate".equals(query.getType())) {
                DefaultComboBoxModel<CapsStrategy> labelCaseModel = new DefaultComboBoxModel<CapsStrategy>(LABEL_CAPITALIZATION);
                String columnNameCapitalization = query.getProperty("cayenne.SQLTemplate.columnNameCapitalization");
                labelCaseModel.setSelectedItem((Object)(columnNameCapitalization != null ? CapsStrategy.valueOf(columnNameCapitalization) : CapsStrategy.DEFAULT));
                this.labelCase.setModel(labelCaseModel);
            }
        }

        @Override
        protected void setEntity(ObjEntity entity) {
            SQLTemplateMainTab.this.setEntity(entity);
        }

        @Override
        public ObjEntity getEntity(QueryDescriptor query) {
            if (query != null && "SQLTemplate".equals(query.getType())) {
                return SQLTemplateMainTab.this.getEntity(query);
            }
            return null;
        }

        @Override
        protected void setFetchingDataObjects(boolean dataObjects) {
            super.setFetchingDataObjects(dataObjects);
            if (!dataObjects) {
                this.setEntity(null);
            }
        }
    }

    final class LabelCapsRenderer
    extends DefaultListCellRenderer {
        LabelCapsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object object, int arg2, boolean arg3, boolean arg4) {
            object = labelCapsLabels.get(object);
            return super.getListCellRendererComponent((JList<?>)list, object, arg2, arg3, arg4);
        }
    }
}

