/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.parser.PatternMatchNode;

class LikeExpressionHelper {
    private static final char WILDCARD_SEQUENCE = '%';
    private static final char WILDCARD_ONE = '_';
    private static final boolean[] ESCAPE_ALPHABET = new boolean[127];
    private static final int ESCAPE_ALPHABET_START = 33;

    LikeExpressionHelper() {
    }

    static void toContains(PatternMatchNode exp) {
        LikeExpressionHelper.escape(exp);
        LikeExpressionHelper.wrap(exp, true, true);
    }

    static void toStartsWith(PatternMatchNode exp) {
        LikeExpressionHelper.escape(exp);
        LikeExpressionHelper.wrap(exp, false, true);
    }

    static void toEndsWith(PatternMatchNode exp) {
        LikeExpressionHelper.escape(exp);
        LikeExpressionHelper.wrap(exp, true, false);
    }

    static void escape(PatternMatchNode exp) {
        Object pattern = exp.getOperand(1);
        if (pattern instanceof String) {
            String pString = pattern.toString();
            int len = pString.length();
            for (int i = 0; i < len; ++i) {
                char c = pString.charAt(i);
                if (c != '%' && c != '_') continue;
                exp.setOperand(1, LikeExpressionHelper.escapeFrom(exp, pString, i, len));
                break;
            }
        }
    }

    private static String escapeFrom(PatternMatchNode exp, String pattern, int firstWildcard, int len) {
        boolean[] mutableEscapeAlphabet = new boolean[127];
        System.arraycopy(ESCAPE_ALPHABET, 33, mutableEscapeAlphabet, 33, 94);
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (c >= '\u007f') continue;
            mutableEscapeAlphabet[c] = false;
        }
        char escapeChar = '\u0000';
        for (int i = 33; i < 127; ++i) {
            if (!mutableEscapeAlphabet[i]) continue;
            escapeChar = (char)i;
            break;
        }
        if (escapeChar == '\u0000') {
            throw new CayenneRuntimeException("Could not properly escape pattern: %s", pattern);
        }
        exp.setEscapeChar(escapeChar);
        StringBuilder buffer = new StringBuilder(len + 1);
        buffer.append(pattern.substring(0, firstWildcard));
        buffer.append(escapeChar).append(pattern.charAt(firstWildcard));
        for (int i = firstWildcard + 1; i < len; ++i) {
            char c = pattern.charAt(i);
            if (c == '%' || c == '_') {
                buffer.append(escapeChar);
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static void wrap(PatternMatchNode exp, boolean start, boolean end2) {
        Object pattern = exp.getOperand(1);
        if (pattern instanceof String) {
            StringBuilder buffer = new StringBuilder();
            if (start) {
                buffer.append('%');
            }
            buffer.append(pattern);
            if (end2) {
                buffer.append('%');
            }
            exp.setOperand(1, buffer.toString());
        }
    }

    static {
        for (int i = 33; i < 127; ++i) {
            if (i == 63 || i == 34 || i == 39 || i == 37 || i == 95) continue;
            LikeExpressionHelper.ESCAPE_ALPHABET[i] = true;
        }
    }
}

