/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.rop.client;

import java.util.Collection;
import java.util.Map;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.configuration.rop.client.ClientRuntime;
import org.apache.cayenne.configuration.rop.client.LocalClientServerChannelProvider;
import org.apache.cayenne.configuration.rop.client.LocalConnectionProvider;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.remote.ClientConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLocalRuntime
extends ClientRuntime {
    public static final String CLIENT_SERVER_CHANNEL_KEY = "client-server-channel";

    private static Module mainModuleOverride(final Injector serverInjector) {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(Key.get(DataChannel.class, ClientLocalRuntime.CLIENT_SERVER_CHANNEL_KEY)).toProviderInstance(new LocalClientServerChannelProvider(serverInjector));
                binder.bind(ClientConnection.class).toProviderInstance(new LocalConnectionProvider());
            }
        };
    }

    public ClientLocalRuntime(Injector serverInjector, Map<String, String> properties, Collection<Module> extraModules) {
        super(properties, ClientLocalRuntime.mergeModules(ClientLocalRuntime.mainModuleOverride(serverInjector), extraModules));
    }

    public ClientLocalRuntime(Injector serverInjector, Map<String, String> properties, Module ... extraModules) {
        super(properties, ClientLocalRuntime.mergeModules(ClientLocalRuntime.mainModuleOverride(serverInjector), extraModules));
    }
}

