/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoableEdit;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.undo.RemoveCompoundUndoableEdit;
import org.apache.cayenne.modeler.undo.RemoveUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.Query;

public class RemoveAction
extends CayenneAction {
    public static String getActionName() {
        return "Remove";
    }

    public RemoveAction(Application application) {
        super(RemoveAction.getActionName(), application);
    }

    protected RemoveAction(String actionName, Application application) {
        super(actionName, application);
    }

    public String getIconName() {
        return "icon-trash.gif";
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public ConfirmRemoveDialog getConfirmDeleteDialog(boolean allowAsking) {
        return new ConfirmRemoveDialog(allowAsking);
    }

    public void performAction(ActionEvent e) {
        this.performAction(e, true);
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ProjectController mediator = this.getProjectController();
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        if (mediator.getCurrentObjEntity() != null) {
            if (dialog.shouldDelete("ObjEntity", mediator.getCurrentObjEntity().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentObjEntity()));
                this.removeObjEntity(mediator.getCurrentDataMap(), mediator.getCurrentObjEntity());
            }
        } else if (mediator.getCurrentDbEntity() != null) {
            if (dialog.shouldDelete("DbEntity", mediator.getCurrentDbEntity().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentDbEntity()));
                this.removeDbEntity(mediator.getCurrentDataMap(), mediator.getCurrentDbEntity());
            }
        } else if (mediator.getCurrentQuery() != null) {
            if (dialog.shouldDelete("query", mediator.getCurrentQuery().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentQuery()));
                this.removeQuery(mediator.getCurrentDataMap(), mediator.getCurrentQuery());
            }
        } else if (mediator.getCurrentProcedure() != null) {
            if (dialog.shouldDelete("procedure", mediator.getCurrentProcedure().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentProcedure()));
                this.removeProcedure(mediator.getCurrentDataMap(), mediator.getCurrentProcedure());
            }
        } else if (mediator.getCurrentEmbeddable() != null) {
            if (dialog.shouldDelete("embeddable", mediator.getCurrentEmbeddable().getClassName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentEmbeddable()));
                this.removeEmbeddable(mediator.getCurrentDataMap(), mediator.getCurrentEmbeddable());
            }
        } else if (mediator.getCurrentDataMap() != null) {
            if (dialog.shouldDelete("data map", mediator.getCurrentDataMap().getName())) {
                if (mediator.getCurrentDataNode() != null) {
                    this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataNode(), mediator.getCurrentDataMap()));
                    this.removeDataMapFromDataNode(mediator.getCurrentDataNode(), mediator.getCurrentDataMap());
                } else {
                    this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataMap()));
                    this.removeDataMap(mediator.getCurrentDataMap());
                }
            }
        } else if (mediator.getCurrentDataNode() != null) {
            if (dialog.shouldDelete("data node", mediator.getCurrentDataNode().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataNode()));
                this.removeDataNode(mediator.getCurrentDataNode());
            }
        } else if (mediator.getCurrentPaths() != null && dialog.shouldDelete("selected objects")) {
            Object[] paths = mediator.getCurrentPaths();
            RemoveCompoundUndoableEdit compoundEdit = new RemoveCompoundUndoableEdit();
            for (Object path : paths) {
                compoundEdit.addEdit(this.removeLastPathComponent(path));
            }
            compoundEdit.end();
            this.application.getUndoManager().addEdit(compoundEdit);
        }
    }

    public void removeDataMap(DataMap map) {
        ProjectController mediator = this.getProjectController();
        DataChannelDescriptor domain = (DataChannelDescriptor)mediator.getProject().getRootNode();
        DataMapEvent e = new DataMapEvent((Object)Application.getFrame(), map, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        domain.getDataMaps().remove(map);
        for (DataNodeDescriptor node : domain.getNodeDescriptors()) {
            if (!node.getDataMapNames().contains(map.getName())) continue;
            this.removeDataMapFromDataNode(node, map);
        }
        mediator.fireDataMapEvent(e);
    }

    public void removeDataNode(DataNodeDescriptor node) {
        ProjectController mediator = this.getProjectController();
        DataChannelDescriptor domain = (DataChannelDescriptor)mediator.getProject().getRootNode();
        DataNodeEvent e = new DataNodeEvent((Object)Application.getFrame(), node, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        domain.getNodeDescriptors().remove(node);
        mediator.fireDataNodeEvent(e);
    }

    public void removeDbEntity(DataMap map, DbEntity ent) {
        ProjectController mediator = this.getProjectController();
        EntityEvent e = new EntityEvent((Object)Application.getFrame(), (Entity)ent, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeDbEntity(ent.getName(), true);
        mediator.fireDbEntityEvent(e);
    }

    public void removeQuery(DataMap map, Query query) {
        ProjectController mediator = this.getProjectController();
        QueryEvent e = new QueryEvent((Object)Application.getFrame(), query, 3, map);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeQuery(query.getName());
        mediator.fireQueryEvent(e);
    }

    public void removeProcedure(DataMap map, Procedure procedure) {
        ProjectController mediator = this.getProjectController();
        ProcedureEvent e = new ProcedureEvent((Object)Application.getFrame(), procedure, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeProcedure(procedure.getName());
        mediator.fireProcedureEvent(e);
    }

    public void removeObjEntity(DataMap map, ObjEntity entity) {
        ProjectController mediator = this.getProjectController();
        EntityEvent e = new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeObjEntity(entity.getName(), true);
        mediator.fireObjEntityEvent(e);
        for (Query query : new ArrayList<Query>(map.getQueries())) {
            AbstractQuery next;
            Object root;
            if (!(query instanceof AbstractQuery) || (root = (next = (AbstractQuery)query).getRoot()) != entity && (!(root instanceof String) || !root.toString().equals(entity.getName()))) continue;
            this.removeQuery(map, next);
        }
    }

    public void removeEmbeddable(DataMap map, Embeddable embeddable) {
        ProjectController mediator = this.getProjectController();
        EmbeddableEvent e = new EmbeddableEvent((Object)Application.getFrame(), embeddable, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeEmbeddable(embeddable.getClassName());
        mediator.fireEmbeddableEvent(e, map);
    }

    public void removeDataMapFromDataNode(DataNodeDescriptor node, DataMap map) {
        ProjectController mediator = this.getProjectController();
        DataNodeEvent e = new DataNodeEvent((Object)Application.getFrame(), node);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        node.getDataMapNames().remove(map.getName());
        mediator.fireDataNodeEvent(e);
    }

    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        if (object instanceof DataChannelDescriptor) {
            return true;
        }
        if (object instanceof DataMap) {
            return true;
        }
        if (object instanceof DataNodeDescriptor) {
            return true;
        }
        if (object instanceof Entity) {
            return true;
        }
        if (object instanceof Attribute) {
            return true;
        }
        if (object instanceof Relationship) {
            return true;
        }
        if (object instanceof Procedure) {
            return true;
        }
        if (object instanceof ProcedureParameter) {
            return true;
        }
        if (object instanceof Embeddable) {
            return true;
        }
        return object instanceof EmbeddableAttribute;
    }

    private UndoableEdit removeLastPathComponent(Object object) {
        RemoveUndoableEdit undo = null;
        if (object instanceof DataMap) {
            undo = new RemoveUndoableEdit(this.application, (DataMap)object);
            this.removeDataMap((DataMap)object);
        } else if (object instanceof DataNodeDescriptor) {
            undo = new RemoveUndoableEdit(this.application, (DataNodeDescriptor)object);
            this.removeDataNode((DataNodeDescriptor)object);
        } else if (object instanceof DbEntity) {
            undo = new RemoveUndoableEdit(((DbEntity)object).getDataMap(), (DbEntity)object);
            this.removeDbEntity(((DbEntity)object).getDataMap(), (DbEntity)object);
        } else if (object instanceof ObjEntity) {
            undo = new RemoveUndoableEdit(((ObjEntity)object).getDataMap(), (ObjEntity)object);
            this.removeObjEntity(((ObjEntity)object).getDataMap(), (ObjEntity)object);
        } else if (object instanceof Query) {
            undo = new RemoveUndoableEdit(((Query)object).getDataMap(), (Query)object);
            this.removeQuery(((Query)object).getDataMap(), (Query)object);
        } else if (object instanceof Procedure) {
            undo = new RemoveUndoableEdit(((Procedure)object).getDataMap(), (Procedure)object);
            this.removeProcedure(((Procedure)object).getDataMap(), (Procedure)object);
        } else if (object instanceof Embeddable) {
            undo = new RemoveUndoableEdit(((Embeddable)object).getDataMap(), (Embeddable)object);
            this.removeEmbeddable(((Embeddable)object).getDataMap(), (Embeddable)object);
        }
        return undo;
    }
}

