/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.objentity.EntitySyncController;
import org.apache.cayenne.modeler.undo.DbEntitySyncUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.util.EntityMergeSupport;

public class DbEntitySyncAction
extends CayenneAction {
    public static String getActionName() {
        return "Sync Dependent ObjEntities with DbEntity";
    }

    public DbEntitySyncAction(Application application) {
        super(DbEntitySyncAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-sync.gif";
    }

    public void performAction(ActionEvent e) {
        this.synchDbEntity();
    }

    protected void synchDbEntity() {
        ProjectController mediator = this.getProjectController();
        DbEntity dbEntity = mediator.getCurrentDbEntity();
        if (dbEntity != null) {
            Iterator<ObjEntity> it = dbEntity.getDataMap().getMappedEntities(dbEntity).iterator();
            if (!it.hasNext()) {
                return;
            }
            EntityMergeSupport merger = new EntitySyncController((CayenneController)Application.getInstance().getFrameController(), dbEntity).createMerger();
            if (merger == null) {
                return;
            }
            DbEntitySyncUndoableEdit undoableEdit = new DbEntitySyncUndoableEdit((DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataMap());
            while (it.hasNext()) {
                ObjEntity entity = it.next();
                DbEntitySyncUndoableEdit dbEntitySyncUndoableEdit = undoableEdit;
                dbEntitySyncUndoableEdit.getClass();
                DbEntitySyncUndoableEdit.EntitySyncUndoableListener listener = new DbEntitySyncUndoableEdit.EntitySyncUndoableListener(dbEntitySyncUndoableEdit, entity);
                merger.addEntityMergeListener(listener);
                if (merger.isRemoveMeaningfulFKs()) {
                    DbEntitySyncUndoableEdit dbEntitySyncUndoableEdit2 = undoableEdit;
                    dbEntitySyncUndoableEdit2.getClass();
                    undoableEdit.addEdit(new DbEntitySyncUndoableEdit.MeaningfulFKsUndoableEdit(dbEntitySyncUndoableEdit2, entity, merger.getMeaningfulFKs(entity)));
                }
                if (merger.synchronizeWithDbEntity(entity)) {
                    mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity, 1));
                }
                merger.removeEntityMergeListener(listener);
            }
            this.application.getUndoManager().addEdit(undoableEdit);
        }
    }
}

