/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.testdomain.model.good;

import java.util.List;

import org.apache.causeway.applib.annotation.DomainObject;
import org.apache.causeway.applib.annotation.Nature;
import org.apache.causeway.applib.annotation.ObjectSupport;

@DomainObject(nature = Nature.VIEW_MODEL)
public class ProperFullyImpl
extends ProperFullyAbstract {

    @Override
    public String title() {
        return "title";
    }

    @Override
    public ObjectSupport.IconResource icon(final ObjectSupport.IconSize iconSize) {
        return new ObjectSupport.ClassPathIconResource("icon");
    }

    @Override
    public String cssClass() {
        return "css";
    }

    @Override
    public String layout() {
        return "layout";
    }

    @Override
    public void sampleAction() {

    }

    @Override
    public String getSampleProperty() {
        return null;
    }

    @Override
    public void setSampleProperty(final String sampleProperty) {
    }

    @Override
    public List<String> getSampleCollection() {
        return null;
    }

    @Override
    public void setSampleCollection(final List<String> sampleCollection) {
    }

}
