/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.BuildSpec;
import org.apache.camel.v1.buildspec.Configuration;
import org.apache.camel.v1.buildspec.ConfigurationBuilder;
import org.apache.camel.v1.buildspec.ConfigurationFluent;
import org.apache.camel.v1.buildspec.Tasks;
import org.apache.camel.v1.buildspec.TasksBuilder;
import org.apache.camel.v1.buildspec.TasksFluent;

public class BuildSpecFluent<A extends BuildSpecFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Integer maxRunningBuilds;
    private String operatorNamespace;
    private ArrayList<TasksBuilder> tasks;
    private String timeout;
    private String toolImage;

    public BuildSpecFluent() {
    }

    public BuildSpecFluent(BuildSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BuildSpec instance) {
        BuildSpec buildSpec = instance = instance != null ? instance : new BuildSpec();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withMaxRunningBuilds(instance.getMaxRunningBuilds());
            this.withOperatorNamespace(instance.getOperatorNamespace());
            this.withTasks(instance.getTasks());
            this.withTimeout(instance.getTimeout());
            this.withToolImage(instance.getToolImage());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Integer getMaxRunningBuilds() {
        return this.maxRunningBuilds;
    }

    public A withMaxRunningBuilds(Integer maxRunningBuilds) {
        this.maxRunningBuilds = maxRunningBuilds;
        return (A)((Object)this);
    }

    public boolean hasMaxRunningBuilds() {
        return this.maxRunningBuilds != null;
    }

    public String getOperatorNamespace() {
        return this.operatorNamespace;
    }

    public A withOperatorNamespace(String operatorNamespace) {
        this.operatorNamespace = operatorNamespace;
        return (A)((Object)this);
    }

    public boolean hasOperatorNamespace() {
        return this.operatorNamespace != null;
    }

    public A addToTasks(int index, Tasks item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList();
        }
        TasksBuilder builder = new TasksBuilder(item);
        if (index < 0 || index >= this.tasks.size()) {
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        } else {
            this._visitables.get((Object)"tasks").add(index, builder);
            this.tasks.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTasks(int index, Tasks item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList();
        }
        TasksBuilder builder = new TasksBuilder(item);
        if (index < 0 || index >= this.tasks.size()) {
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        } else {
            this._visitables.get((Object)"tasks").set(index, builder);
            this.tasks.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTasks(Tasks ... items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList();
        }
        for (Tasks item : items) {
            TasksBuilder builder = new TasksBuilder(item);
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTasks(Collection<Tasks> items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList();
        }
        for (Tasks item : items) {
            TasksBuilder builder = new TasksBuilder(item);
            this._visitables.get((Object)"tasks").add(builder);
            this.tasks.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTasks(Tasks ... items) {
        if (this.tasks == null) {
            return (A)((Object)this);
        }
        for (Tasks item : items) {
            TasksBuilder builder = new TasksBuilder(item);
            this._visitables.get((Object)"tasks").remove((Object)builder);
            this.tasks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTasks(Collection<Tasks> items) {
        if (this.tasks == null) {
            return (A)((Object)this);
        }
        for (Tasks item : items) {
            TasksBuilder builder = new TasksBuilder(item);
            this._visitables.get((Object)"tasks").remove((Object)builder);
            this.tasks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTasks(Predicate<TasksBuilder> predicate) {
        if (this.tasks == null) {
            return (A)((Object)this);
        }
        Iterator<TasksBuilder> each = this.tasks.iterator();
        List visitables = this._visitables.get((Object)"tasks");
        while (each.hasNext()) {
            TasksBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Tasks> buildTasks() {
        return this.tasks != null ? BuildSpecFluent.build(this.tasks) : null;
    }

    public Tasks buildTask(int index) {
        return this.tasks.get(index).build();
    }

    public Tasks buildFirstTask() {
        return this.tasks.get(0).build();
    }

    public Tasks buildLastTask() {
        return this.tasks.get(this.tasks.size() - 1).build();
    }

    public Tasks buildMatchingTask(Predicate<TasksBuilder> predicate) {
        for (TasksBuilder item : this.tasks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTask(Predicate<TasksBuilder> predicate) {
        for (TasksBuilder item : this.tasks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTasks(List<Tasks> tasks) {
        if (this.tasks != null) {
            this._visitables.get((Object)"tasks").clear();
        }
        if (tasks != null) {
            this.tasks = new ArrayList();
            for (Tasks item : tasks) {
                this.addToTasks(item);
            }
        } else {
            this.tasks = null;
        }
        return (A)((Object)this);
    }

    public A withTasks(Tasks ... tasks) {
        if (this.tasks != null) {
            this.tasks.clear();
            this._visitables.remove((Object)"tasks");
        }
        if (tasks != null) {
            for (Tasks item : tasks) {
                this.addToTasks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTasks() {
        return this.tasks != null && !this.tasks.isEmpty();
    }

    public TasksNested<A> addNewTask() {
        return new TasksNested(-1, null);
    }

    public TasksNested<A> addNewTaskLike(Tasks item) {
        return new TasksNested(-1, item);
    }

    public TasksNested<A> setNewTaskLike(int index, Tasks item) {
        return new TasksNested(index, item);
    }

    public TasksNested<A> editTask(int index) {
        if (this.tasks.size() <= index) {
            throw new RuntimeException("Can't edit tasks. Index exceeds size.");
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    public TasksNested<A> editFirstTask() {
        if (this.tasks.size() == 0) {
            throw new RuntimeException("Can't edit first tasks. The list is empty.");
        }
        return this.setNewTaskLike(0, this.buildTask(0));
    }

    public TasksNested<A> editLastTask() {
        int index = this.tasks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tasks. The list is empty.");
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    public TasksNested<A> editMatchingTask(Predicate<TasksBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tasks.size(); ++i) {
            if (!predicate.test(this.tasks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tasks. No match found.");
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    public String getTimeout() {
        return this.timeout;
    }

    public A withTimeout(String timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public String getToolImage() {
        return this.toolImage;
    }

    public A withToolImage(String toolImage) {
        this.toolImage = toolImage;
        return (A)((Object)this);
    }

    public boolean hasToolImage() {
        return this.toolImage != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSpecFluent that = (BuildSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.maxRunningBuilds, that.maxRunningBuilds)) {
            return false;
        }
        if (!Objects.equals(this.operatorNamespace, that.operatorNamespace)) {
            return false;
        }
        if (!Objects.equals(this.tasks, that.tasks)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        return Objects.equals(this.toolImage, that.toolImage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.maxRunningBuilds, this.operatorNamespace, this.tasks, this.timeout, this.toolImage, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.maxRunningBuilds != null) {
            sb.append("maxRunningBuilds:");
            sb.append(this.maxRunningBuilds + ",");
        }
        if (this.operatorNamespace != null) {
            sb.append("operatorNamespace:");
            sb.append(this.operatorNamespace + ",");
        }
        if (this.tasks != null && !this.tasks.isEmpty()) {
            sb.append("tasks:");
            sb.append(this.tasks + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout + ",");
        }
        if (this.toolImage != null) {
            sb.append("toolImage:");
            sb.append(this.toolImage);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)BuildSpecFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class TasksNested<N>
    extends TasksFluent<TasksNested<N>>
    implements Nested<N> {
        TasksBuilder builder;
        int index;

        TasksNested(int index, Tasks item) {
            this.index = index;
            this.builder = new TasksBuilder(this, item);
        }

        public N and() {
            return (N)BuildSpecFluent.this.setToTasks(this.index, this.builder.build());
        }

        public N endTask() {
            return this.and();
        }
    }
}

