/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes.Csi;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes.csi.NodePublishSecretRef;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes.csi.NodePublishSecretRefBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes.csi.NodePublishSecretRefFluent;

public class CsiFluent<A extends CsiFluent<A>>
extends BaseFluent<A> {
    private String driver;
    private String fsType;
    private NodePublishSecretRefBuilder nodePublishSecretRef;
    private Boolean readOnly;
    private Map<String, String> volumeAttributes;

    public CsiFluent() {
    }

    public CsiFluent(Csi instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Csi instance) {
        Csi csi = instance = instance != null ? instance : new Csi();
        if (instance != null) {
            this.withDriver(instance.getDriver());
            this.withFsType(instance.getFsType());
            this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
            this.withReadOnly(instance.getReadOnly());
            this.withVolumeAttributes(instance.getVolumeAttributes());
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)((Object)this);
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)((Object)this);
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public NodePublishSecretRef buildNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    public A withNodePublishSecretRef(NodePublishSecretRef nodePublishSecretRef) {
        this._visitables.remove((Object)"nodePublishSecretRef");
        if (nodePublishSecretRef != null) {
            this.nodePublishSecretRef = new NodePublishSecretRefBuilder(nodePublishSecretRef);
            this._visitables.get((Object)"nodePublishSecretRef").add(this.nodePublishSecretRef);
        } else {
            this.nodePublishSecretRef = null;
            this._visitables.get((Object)"nodePublishSecretRef").remove((Object)this.nodePublishSecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasNodePublishSecretRef() {
        return this.nodePublishSecretRef != null;
    }

    public NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
        return new NodePublishSecretRefNested(null);
    }

    public NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(NodePublishSecretRef item) {
        return new NodePublishSecretRefNested(item);
    }

    public NodePublishSecretRefNested<A> editIntegrationNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(null));
    }

    public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(new NodePublishSecretRefBuilder().build()));
    }

    public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(NodePublishSecretRef item) {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(item));
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A addToVolumeAttributes(String key, String value) {
        if (this.volumeAttributes == null && key != null && value != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.volumeAttributes.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null && map != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.volumeAttributes.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeAttributes(String key) {
        if (this.volumeAttributes == null) {
            return (A)((Object)this);
        }
        if (key != null && this.volumeAttributes != null) {
            this.volumeAttributes.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.volumeAttributes == null) continue;
                this.volumeAttributes.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public <K, V> A withVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes == null ? null : new LinkedHashMap<String, String>(volumeAttributes);
        return (A)((Object)this);
    }

    public boolean hasVolumeAttributes() {
        return this.volumeAttributes != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CsiFluent that = (CsiFluent)((Object)o);
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals((Object)this.nodePublishSecretRef, (Object)that.nodePublishSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        return Objects.equals(this.volumeAttributes, that.volumeAttributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.driver, this.fsType, this.nodePublishSecretRef, this.readOnly, this.volumeAttributes, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.nodePublishSecretRef != null) {
            sb.append("nodePublishSecretRef:");
            sb.append(this.nodePublishSecretRef + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.volumeAttributes != null && !this.volumeAttributes.isEmpty()) {
            sb.append("volumeAttributes:");
            sb.append(this.volumeAttributes);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class NodePublishSecretRefNested<N>
    extends NodePublishSecretRefFluent<NodePublishSecretRefNested<N>>
    implements Nested<N> {
        NodePublishSecretRefBuilder builder;

        NodePublishSecretRefNested(NodePublishSecretRef item) {
            this.builder = new NodePublishSecretRefBuilder(this, item);
        }

        public N and() {
            return (N)CsiFluent.this.withNodePublishSecretRef(this.builder.build());
        }

        public N endIntegrationNodePublishSecretRef() {
            return this.and();
        }
    }
}

