/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.IntegrationStatus;
import org.apache.camel.v1.integrationstatus.Conditions;
import org.apache.camel.v1.integrationstatus.ConditionsBuilder;
import org.apache.camel.v1.integrationstatus.ConditionsFluent;
import org.apache.camel.v1.integrationstatus.Configuration;
import org.apache.camel.v1.integrationstatus.ConfigurationBuilder;
import org.apache.camel.v1.integrationstatus.ConfigurationFluent;
import org.apache.camel.v1.integrationstatus.GeneratedSources;
import org.apache.camel.v1.integrationstatus.GeneratedSourcesBuilder;
import org.apache.camel.v1.integrationstatus.GeneratedSourcesFluent;
import org.apache.camel.v1.integrationstatus.IntegrationKit;
import org.apache.camel.v1.integrationstatus.IntegrationKitBuilder;
import org.apache.camel.v1.integrationstatus.IntegrationKitFluent;

public class IntegrationStatusFluent<A extends IntegrationStatusFluent<A>>
extends BaseFluent<A> {
    private List<String> capabilities;
    private ArrayList<ConditionsBuilder> conditions;
    private ArrayList<ConfigurationBuilder> configuration;
    private List<String> dependencies;
    private String digest;
    private ArrayList<GeneratedSourcesBuilder> generatedSources;
    private String image;
    private IntegrationKitBuilder integrationKit;
    private ZonedDateTime lastInitTimestamp;
    private Long observedGeneration;
    private String phase;
    private String platform;
    private String profile;
    private Integer replicas;
    private String runtimeProvider;
    private String runtimeVersion;
    private String selector;
    private String version;

    public IntegrationStatusFluent() {
    }

    public IntegrationStatusFluent(IntegrationStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IntegrationStatus instance) {
        IntegrationStatus integrationStatus = instance = instance != null ? instance : new IntegrationStatus();
        if (instance != null) {
            this.withCapabilities(instance.getCapabilities());
            this.withConditions(instance.getConditions());
            this.withConfiguration(instance.getConfiguration());
            this.withDependencies(instance.getDependencies());
            this.withDigest(instance.getDigest());
            this.withGeneratedSources(instance.getGeneratedSources());
            this.withImage(instance.getImage());
            this.withIntegrationKit(instance.getIntegrationKit());
            this.withLastInitTimestamp(instance.getLastInitTimestamp());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPhase(instance.getPhase());
            this.withPlatform(instance.getPlatform());
            this.withProfile(instance.getProfile());
            this.withReplicas(instance.getReplicas());
            this.withRuntimeProvider(instance.getRuntimeProvider());
            this.withRuntimeVersion(instance.getRuntimeVersion());
            this.withSelector(instance.getSelector());
            this.withVersion(instance.getVersion());
        }
    }

    public A addToCapabilities(int index, String item) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        this.capabilities.add(index, item);
        return (A)((Object)this);
    }

    public A setToCapabilities(int index, String item) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        this.capabilities.set(index, item);
        return (A)((Object)this);
    }

    public A addToCapabilities(String ... items) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.capabilities.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCapabilities(Collection<String> items) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.capabilities.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCapabilities(String ... items) {
        if (this.capabilities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.capabilities.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCapabilities(Collection<String> items) {
        if (this.capabilities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.capabilities.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public String getCapability(int index) {
        return this.capabilities.get(index);
    }

    public String getFirstCapability() {
        return this.capabilities.get(0);
    }

    public String getLastCapability() {
        return this.capabilities.get(this.capabilities.size() - 1);
    }

    public String getMatchingCapability(Predicate<String> predicate) {
        for (String item : this.capabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCapability(Predicate<String> predicate) {
        for (String item : this.capabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCapabilities(List<String> capabilities) {
        if (capabilities != null) {
            this.capabilities = new ArrayList<String>();
            for (String item : capabilities) {
                this.addToCapabilities(item);
            }
        } else {
            this.capabilities = null;
        }
        return (A)((Object)this);
    }

    public A withCapabilities(String ... capabilities) {
        if (this.capabilities != null) {
            this.capabilities.clear();
            this._visitables.remove((Object)"capabilities");
        }
        if (capabilities != null) {
            for (String item : capabilities) {
                this.addToCapabilities(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCapabilities() {
        return this.capabilities != null && !this.capabilities.isEmpty();
    }

    public A addToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Conditions ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationstatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Conditions ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationstatusConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationstatusConditions(Predicate<ConditionsBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionsBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Conditions> buildConditions() {
        return this.conditions != null ? IntegrationStatusFluent.build(this.conditions) : null;
    }

    public Conditions buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Conditions buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Conditions buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Conditions buildMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Conditions> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Conditions ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Conditions item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Conditions item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToConfiguration(int index, Configuration item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationBuilder builder = new ConfigurationBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").add(index, builder);
            this.configuration.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConfiguration(int index, Configuration item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationBuilder builder = new ConfigurationBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").set(index, builder);
            this.configuration.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConfiguration(Configuration ... items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConfiguration(Collection<Configuration> items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConfiguration(Configuration ... items) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").remove((Object)builder);
            this.configuration.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfiguration(Collection<Configuration> items) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").remove((Object)builder);
            this.configuration.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConfiguration(Predicate<ConfigurationBuilder> predicate) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        Iterator<ConfigurationBuilder> each = this.configuration.iterator();
        List visitables = this._visitables.get((Object)"configuration");
        while (each.hasNext()) {
            ConfigurationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Configuration> buildConfiguration() {
        return this.configuration != null ? IntegrationStatusFluent.build(this.configuration) : null;
    }

    public Configuration buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public Configuration buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public Configuration buildLastConfiguration() {
        return this.configuration.get(this.configuration.size() - 1).build();
    }

    public Configuration buildMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        for (ConfigurationBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        for (ConfigurationBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfiguration(List<Configuration> configuration) {
        if (this.configuration != null) {
            this._visitables.get((Object)"configuration").clear();
        }
        if (configuration != null) {
            this.configuration = new ArrayList();
            for (Configuration item : configuration) {
                this.addToConfiguration(item);
            }
        } else {
            this.configuration = null;
        }
        return (A)((Object)this);
    }

    public A withConfiguration(Configuration ... configuration) {
        if (this.configuration != null) {
            this.configuration.clear();
            this._visitables.remove((Object)"configuration");
        }
        if (configuration != null) {
            for (Configuration item : configuration) {
                this.addToConfiguration(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null && !this.configuration.isEmpty();
    }

    public ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNested(-1, null);
    }

    public ConfigurationNested<A> addNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(-1, item);
    }

    public ConfigurationNested<A> setNewConfigurationLike(int index, Configuration item) {
        return new ConfigurationNested(index, item);
    }

    public ConfigurationNested<A> editConfiguration(int index) {
        if (this.configuration.size() <= index) {
            throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationNested<A> editFirstConfiguration() {
        if (this.configuration.size() == 0) {
            throw new RuntimeException("Can't edit first configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(0, this.buildConfiguration(0));
    }

    public ConfigurationNested<A> editLastConfiguration() {
        int index = this.configuration.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configuration.size(); ++i) {
            if (!predicate.test(this.configuration.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configuration. No match found.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public A addToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)((Object)this);
    }

    public A setToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)((Object)this);
    }

    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(String ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependencies(List<String> dependencies) {
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)((Object)this);
    }

    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public String getDigest() {
        return this.digest;
    }

    public A withDigest(String digest) {
        this.digest = digest;
        return (A)((Object)this);
    }

    public boolean hasDigest() {
        return this.digest != null;
    }

    public A addToGeneratedSources(int index, GeneratedSources item) {
        if (this.generatedSources == null) {
            this.generatedSources = new ArrayList();
        }
        GeneratedSourcesBuilder builder = new GeneratedSourcesBuilder(item);
        if (index < 0 || index >= this.generatedSources.size()) {
            this._visitables.get((Object)"generatedSources").add(builder);
            this.generatedSources.add(builder);
        } else {
            this._visitables.get((Object)"generatedSources").add(index, builder);
            this.generatedSources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToGeneratedSources(int index, GeneratedSources item) {
        if (this.generatedSources == null) {
            this.generatedSources = new ArrayList();
        }
        GeneratedSourcesBuilder builder = new GeneratedSourcesBuilder(item);
        if (index < 0 || index >= this.generatedSources.size()) {
            this._visitables.get((Object)"generatedSources").add(builder);
            this.generatedSources.add(builder);
        } else {
            this._visitables.get((Object)"generatedSources").set(index, builder);
            this.generatedSources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToGeneratedSources(GeneratedSources ... items) {
        if (this.generatedSources == null) {
            this.generatedSources = new ArrayList();
        }
        for (GeneratedSources item : items) {
            GeneratedSourcesBuilder builder = new GeneratedSourcesBuilder(item);
            this._visitables.get((Object)"generatedSources").add(builder);
            this.generatedSources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToGeneratedSources(Collection<GeneratedSources> items) {
        if (this.generatedSources == null) {
            this.generatedSources = new ArrayList();
        }
        for (GeneratedSources item : items) {
            GeneratedSourcesBuilder builder = new GeneratedSourcesBuilder(item);
            this._visitables.get((Object)"generatedSources").add(builder);
            this.generatedSources.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromGeneratedSources(GeneratedSources ... items) {
        if (this.generatedSources == null) {
            return (A)((Object)this);
        }
        for (GeneratedSources item : items) {
            GeneratedSourcesBuilder builder = new GeneratedSourcesBuilder(item);
            this._visitables.get((Object)"generatedSources").remove((Object)builder);
            this.generatedSources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGeneratedSources(Collection<GeneratedSources> items) {
        if (this.generatedSources == null) {
            return (A)((Object)this);
        }
        for (GeneratedSources item : items) {
            GeneratedSourcesBuilder builder = new GeneratedSourcesBuilder(item);
            this._visitables.get((Object)"generatedSources").remove((Object)builder);
            this.generatedSources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromGeneratedSources(Predicate<GeneratedSourcesBuilder> predicate) {
        if (this.generatedSources == null) {
            return (A)((Object)this);
        }
        Iterator<GeneratedSourcesBuilder> each = this.generatedSources.iterator();
        List visitables = this._visitables.get((Object)"generatedSources");
        while (each.hasNext()) {
            GeneratedSourcesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GeneratedSources> buildGeneratedSources() {
        return this.generatedSources != null ? IntegrationStatusFluent.build(this.generatedSources) : null;
    }

    public GeneratedSources buildGeneratedSource(int index) {
        return this.generatedSources.get(index).build();
    }

    public GeneratedSources buildFirstGeneratedSource() {
        return this.generatedSources.get(0).build();
    }

    public GeneratedSources buildLastGeneratedSource() {
        return this.generatedSources.get(this.generatedSources.size() - 1).build();
    }

    public GeneratedSources buildMatchingGeneratedSource(Predicate<GeneratedSourcesBuilder> predicate) {
        for (GeneratedSourcesBuilder item : this.generatedSources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGeneratedSource(Predicate<GeneratedSourcesBuilder> predicate) {
        for (GeneratedSourcesBuilder item : this.generatedSources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGeneratedSources(List<GeneratedSources> generatedSources) {
        if (this.generatedSources != null) {
            this._visitables.get((Object)"generatedSources").clear();
        }
        if (generatedSources != null) {
            this.generatedSources = new ArrayList();
            for (GeneratedSources item : generatedSources) {
                this.addToGeneratedSources(item);
            }
        } else {
            this.generatedSources = null;
        }
        return (A)((Object)this);
    }

    public A withGeneratedSources(GeneratedSources ... generatedSources) {
        if (this.generatedSources != null) {
            this.generatedSources.clear();
            this._visitables.remove((Object)"generatedSources");
        }
        if (generatedSources != null) {
            for (GeneratedSources item : generatedSources) {
                this.addToGeneratedSources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGeneratedSources() {
        return this.generatedSources != null && !this.generatedSources.isEmpty();
    }

    public GeneratedSourcesNested<A> addNewGeneratedSource() {
        return new GeneratedSourcesNested(-1, null);
    }

    public GeneratedSourcesNested<A> addNewGeneratedSourceLike(GeneratedSources item) {
        return new GeneratedSourcesNested(-1, item);
    }

    public GeneratedSourcesNested<A> setNewGeneratedSourceLike(int index, GeneratedSources item) {
        return new GeneratedSourcesNested(index, item);
    }

    public GeneratedSourcesNested<A> editGeneratedSource(int index) {
        if (this.generatedSources.size() <= index) {
            throw new RuntimeException("Can't edit generatedSources. Index exceeds size.");
        }
        return this.setNewGeneratedSourceLike(index, this.buildGeneratedSource(index));
    }

    public GeneratedSourcesNested<A> editFirstGeneratedSource() {
        if (this.generatedSources.size() == 0) {
            throw new RuntimeException("Can't edit first generatedSources. The list is empty.");
        }
        return this.setNewGeneratedSourceLike(0, this.buildGeneratedSource(0));
    }

    public GeneratedSourcesNested<A> editLastGeneratedSource() {
        int index = this.generatedSources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last generatedSources. The list is empty.");
        }
        return this.setNewGeneratedSourceLike(index, this.buildGeneratedSource(index));
    }

    public GeneratedSourcesNested<A> editMatchingGeneratedSource(Predicate<GeneratedSourcesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.generatedSources.size(); ++i) {
            if (!predicate.test(this.generatedSources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching generatedSources. No match found.");
        }
        return this.setNewGeneratedSourceLike(index, this.buildGeneratedSource(index));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public IntegrationKit buildIntegrationKit() {
        return this.integrationKit != null ? this.integrationKit.build() : null;
    }

    public A withIntegrationKit(IntegrationKit integrationKit) {
        this._visitables.remove((Object)"integrationKit");
        if (integrationKit != null) {
            this.integrationKit = new IntegrationKitBuilder(integrationKit);
            this._visitables.get((Object)"integrationKit").add(this.integrationKit);
        } else {
            this.integrationKit = null;
            this._visitables.get((Object)"integrationKit").remove((Object)this.integrationKit);
        }
        return (A)((Object)this);
    }

    public boolean hasIntegrationKit() {
        return this.integrationKit != null;
    }

    public IntegrationKitNested<A> withNewIntegrationKit() {
        return new IntegrationKitNested(null);
    }

    public IntegrationKitNested<A> withNewIntegrationKitLike(IntegrationKit item) {
        return new IntegrationKitNested(item);
    }

    public IntegrationKitNested<A> editIntegrationstatusIntegrationKit() {
        return this.withNewIntegrationKitLike(Optional.ofNullable(this.buildIntegrationKit()).orElse(null));
    }

    public IntegrationKitNested<A> editOrNewIntegrationKit() {
        return this.withNewIntegrationKitLike(Optional.ofNullable(this.buildIntegrationKit()).orElse(new IntegrationKitBuilder().build()));
    }

    public IntegrationKitNested<A> editOrNewIntegrationKitLike(IntegrationKit item) {
        return this.withNewIntegrationKitLike(Optional.ofNullable(this.buildIntegrationKit()).orElse(item));
    }

    public ZonedDateTime getLastInitTimestamp() {
        return this.lastInitTimestamp;
    }

    public A withLastInitTimestamp(ZonedDateTime lastInitTimestamp) {
        this.lastInitTimestamp = lastInitTimestamp;
        return (A)((Object)this);
    }

    public boolean hasLastInitTimestamp() {
        return this.lastInitTimestamp != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public String getPlatform() {
        return this.platform;
    }

    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)((Object)this);
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile = profile;
        return (A)((Object)this);
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public A withRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
        return (A)((Object)this);
    }

    public boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return (A)((Object)this);
    }

    public boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    public String getSelector() {
        return this.selector;
    }

    public A withSelector(String selector) {
        this.selector = selector;
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationStatusFluent that = (IntegrationStatusFluent)((Object)o);
        if (!Objects.equals(this.capabilities, that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.configuration, that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.digest, that.digest)) {
            return false;
        }
        if (!Objects.equals(this.generatedSources, that.generatedSources)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals((Object)this.integrationKit, (Object)that.integrationKit)) {
            return false;
        }
        if (!Objects.equals(this.lastInitTimestamp, that.lastInitTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.runtimeProvider, that.runtimeProvider)) {
            return false;
        }
        if (!Objects.equals(this.runtimeVersion, that.runtimeVersion)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.conditions, this.configuration, this.dependencies, this.digest, this.generatedSources, this.image, this.integrationKit, this.lastInitTimestamp, this.observedGeneration, this.phase, this.platform, this.profile, this.replicas, this.runtimeProvider, this.runtimeVersion, this.selector, this.version, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.capabilities != null && !this.capabilities.isEmpty()) {
            sb.append("capabilities:");
            sb.append(this.capabilities + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.configuration != null && !this.configuration.isEmpty()) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.digest != null) {
            sb.append("digest:");
            sb.append(this.digest + ",");
        }
        if (this.generatedSources != null && !this.generatedSources.isEmpty()) {
            sb.append("generatedSources:");
            sb.append(this.generatedSources + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.integrationKit != null) {
            sb.append("integrationKit:");
            sb.append(this.integrationKit + ",");
        }
        if (this.lastInitTimestamp != null) {
            sb.append("lastInitTimestamp:");
            sb.append(this.lastInitTimestamp + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.runtimeProvider != null) {
            sb.append("runtimeProvider:");
            sb.append(this.runtimeProvider + ",");
        }
        if (this.runtimeVersion != null) {
            sb.append("runtimeVersion:");
            sb.append(this.runtimeVersion + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends ConditionsFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionsBuilder builder;
        int index;

        ConditionsNested(int index, Conditions item) {
            this.index = index;
            this.builder = new ConditionsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endIntegrationstatusCondition() {
            return this.and();
        }
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;
        int index;

        ConfigurationNested(int index, Configuration item) {
            this.index = index;
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationStatusFluent.this.setToConfiguration(this.index, this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class GeneratedSourcesNested<N>
    extends GeneratedSourcesFluent<GeneratedSourcesNested<N>>
    implements Nested<N> {
        GeneratedSourcesBuilder builder;
        int index;

        GeneratedSourcesNested(int index, GeneratedSources item) {
            this.index = index;
            this.builder = new GeneratedSourcesBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationStatusFluent.this.setToGeneratedSources(this.index, this.builder.build());
        }

        public N endGeneratedSource() {
            return this.and();
        }
    }

    public class IntegrationKitNested<N>
    extends IntegrationKitFluent<IntegrationKitNested<N>>
    implements Nested<N> {
        IntegrationKitBuilder builder;

        IntegrationKitNested(IntegrationKit item) {
            this.builder = new IntegrationKitBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationStatusFluent.this.withIntegrationKit(this.builder.build());
        }

        public N endIntegrationstatusIntegrationKit() {
            return this.and();
        }
    }
}

