/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import org.apache.camel.v1.integrationprofilestatus.traits.builder.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "baseImage", "configuration", "enabled", "incrementalImageBuild", "limitCPU", "limitMemory", "mavenProfiles", "nodeSelector", "orderStrategy", "platforms", "properties", "requestCPU", "requestMemory", "strategy", "tasks", "tasksFilter", "tasksLimitCPU", "tasksLimitMemory", "tasksRequestCPU", "tasksRequestMemory", "verbose"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Builder
implements KubernetesResource {
    @JsonProperty(value="annotations")
    @JsonPropertyDescription(value="When using `pod` strategy, annotation to use for the builder pod.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> annotations;
    @JsonProperty(value="baseImage")
    @JsonPropertyDescription(value="Specify a base image")
    @JsonSetter(nulls=Nulls.SKIP)
    private String baseImage;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Deprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="incrementalImageBuild")
    @JsonPropertyDescription(value="Use the incremental image build option, to reuse existing containers (default `true`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean incrementalImageBuild;
    @JsonProperty(value="limitCPU")
    @JsonPropertyDescription(value="When using `pod` strategy, the maximum amount of CPU required by the pod builder. Deprecated: use TasksRequestCPU instead with task name `builder`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitCPU;
    @JsonProperty(value="limitMemory")
    @JsonPropertyDescription(value="When using `pod` strategy, the maximum amount of memory required by the pod builder. Deprecated: use TasksRequestCPU instead with task name `builder`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String limitMemory;
    @JsonProperty(value="mavenProfiles")
    @JsonPropertyDescription(value="A list of references pointing to configmaps/secrets that contains a maven profile. This configmap/secret is a resource of the IntegrationKit created, therefore it needs to be present in the namespace where the operator is going to create the IntegrationKit. The content of the maven profile is expected to be a text containing a valid maven profile starting with `<profile>` and ending with `</profile>` that will be integrated as an inline profile in the POM. Syntax: [configmap|secret]:name[/key], where name represents the resource name, key optionally represents the resource key to be filtered (default key value = profile.xml).")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> mavenProfiles;
    @JsonProperty(value="nodeSelector")
    @JsonPropertyDescription(value="Defines a set of nodes the builder pod is eligible to be scheduled on, based on labels on the node.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> nodeSelector;
    @JsonProperty(value="orderStrategy")
    @JsonPropertyDescription(value="The build order strategy to use, either `dependencies`, `fifo` or `sequential` (default `sequential`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private OrderStrategy orderStrategy;
    @JsonProperty(value="platforms")
    @JsonPropertyDescription(value="The list of manifest platforms to use to build a container image (default `linux/amd64`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> platforms;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="A list of properties to be provided to the build task")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> properties;
    @JsonProperty(value="requestCPU")
    @JsonPropertyDescription(value="When using `pod` strategy, the minimum amount of CPU required by the pod builder. Deprecated: use TasksRequestCPU instead with task name `builder`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestCPU;
    @JsonProperty(value="requestMemory")
    @JsonPropertyDescription(value="When using `pod` strategy, the minimum amount of memory required by the pod builder. Deprecated: use TasksRequestCPU instead with task name `builder`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String requestMemory;
    @JsonProperty(value="strategy")
    @JsonPropertyDescription(value="The strategy to use, either `pod` or `routine` (default `routine`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Strategy strategy;
    @JsonProperty(value="tasks")
    @JsonPropertyDescription(value="A list of tasks to be executed (available only when using `pod` strategy) with format `<name>;<container-image>;<container-command>`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> tasks;
    @JsonProperty(value="tasksFilter")
    @JsonPropertyDescription(value="A list of tasks sorted by the order of execution in a csv format, ie, `<taskName1>,<taskName2>,...`. Mind that you must include also the operator tasks (`builder`, `quarkus-native`, `package`, `jib`, `spectrum`, `s2i`) if you need to execute them. Useful only with `pod` strategy.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String tasksFilter;
    @JsonProperty(value="tasksLimitCPU")
    @JsonPropertyDescription(value="A list of limit cpu configuration for the specific task with format `<task-name>:<limit-cpu-conf>`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> tasksLimitCPU;
    @JsonProperty(value="tasksLimitMemory")
    @JsonPropertyDescription(value="A list of limit memory configuration for the specific task with format `<task-name>:<limit-memory-conf>`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> tasksLimitMemory;
    @JsonProperty(value="tasksRequestCPU")
    @JsonPropertyDescription(value="A list of request cpu configuration for the specific task with format `<task-name>:<request-cpu-conf>`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> tasksRequestCPU;
    @JsonProperty(value="tasksRequestMemory")
    @JsonPropertyDescription(value="A list of request memory configuration for the specific task with format `<task-name>:<request-memory-conf>`.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> tasksRequestMemory;
    @JsonProperty(value="verbose")
    @JsonPropertyDescription(value="Enable verbose logging on build components that support it (e.g. Kaniko build pod). Deprecated no longer in use")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean verbose;

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getIncrementalImageBuild() {
        return this.incrementalImageBuild;
    }

    public void setIncrementalImageBuild(Boolean incrementalImageBuild) {
        this.incrementalImageBuild = incrementalImageBuild;
    }

    public String getLimitCPU() {
        return this.limitCPU;
    }

    public void setLimitCPU(String limitCPU) {
        this.limitCPU = limitCPU;
    }

    public String getLimitMemory() {
        return this.limitMemory;
    }

    public void setLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
    }

    public List<String> getMavenProfiles() {
        return this.mavenProfiles;
    }

    public void setMavenProfiles(List<String> mavenProfiles) {
        this.mavenProfiles = mavenProfiles;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public OrderStrategy getOrderStrategy() {
        return this.orderStrategy;
    }

    public void setOrderStrategy(OrderStrategy orderStrategy) {
        this.orderStrategy = orderStrategy;
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(List<String> platforms) {
        this.platforms = platforms;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public String getRequestCPU() {
        return this.requestCPU;
    }

    public void setRequestCPU(String requestCPU) {
        this.requestCPU = requestCPU;
    }

    public String getRequestMemory() {
        return this.requestMemory;
    }

    public void setRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public List<String> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<String> tasks) {
        this.tasks = tasks;
    }

    public String getTasksFilter() {
        return this.tasksFilter;
    }

    public void setTasksFilter(String tasksFilter) {
        this.tasksFilter = tasksFilter;
    }

    public List<String> getTasksLimitCPU() {
        return this.tasksLimitCPU;
    }

    public void setTasksLimitCPU(List<String> tasksLimitCPU) {
        this.tasksLimitCPU = tasksLimitCPU;
    }

    public List<String> getTasksLimitMemory() {
        return this.tasksLimitMemory;
    }

    public void setTasksLimitMemory(List<String> tasksLimitMemory) {
        this.tasksLimitMemory = tasksLimitMemory;
    }

    public List<String> getTasksRequestCPU() {
        return this.tasksRequestCPU;
    }

    public void setTasksRequestCPU(List<String> tasksRequestCPU) {
        this.tasksRequestCPU = tasksRequestCPU;
    }

    public List<String> getTasksRequestMemory() {
        return this.tasksRequestMemory;
    }

    public void setTasksRequestMemory(List<String> tasksRequestMemory) {
        this.tasksRequestMemory = tasksRequestMemory;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        return "Builder(annotations=" + this.getAnnotations() + ", baseImage=" + this.getBaseImage() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", incrementalImageBuild=" + this.getIncrementalImageBuild() + ", limitCPU=" + this.getLimitCPU() + ", limitMemory=" + this.getLimitMemory() + ", mavenProfiles=" + this.getMavenProfiles() + ", nodeSelector=" + this.getNodeSelector() + ", orderStrategy=" + this.getOrderStrategy() + ", platforms=" + this.getPlatforms() + ", properties=" + this.getProperties() + ", requestCPU=" + this.getRequestCPU() + ", requestMemory=" + this.getRequestMemory() + ", strategy=" + this.getStrategy() + ", tasks=" + this.getTasks() + ", tasksFilter=" + this.getTasksFilter() + ", tasksLimitCPU=" + this.getTasksLimitCPU() + ", tasksLimitMemory=" + this.getTasksLimitMemory() + ", tasksRequestCPU=" + this.getTasksRequestCPU() + ", tasksRequestMemory=" + this.getTasksRequestMemory() + ", verbose=" + this.getVerbose() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Builder)) {
            return false;
        }
        Builder other = (Builder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$incrementalImageBuild = this.getIncrementalImageBuild();
        Boolean other$incrementalImageBuild = other.getIncrementalImageBuild();
        if (this$incrementalImageBuild == null ? other$incrementalImageBuild != null : !((Object)this$incrementalImageBuild).equals(other$incrementalImageBuild)) {
            return false;
        }
        Boolean this$verbose = this.getVerbose();
        Boolean other$verbose = other.getVerbose();
        if (this$verbose == null ? other$verbose != null : !((Object)this$verbose).equals(other$verbose)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$baseImage = this.getBaseImage();
        String other$baseImage = other.getBaseImage();
        if (this$baseImage == null ? other$baseImage != null : !this$baseImage.equals(other$baseImage)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$limitCPU = this.getLimitCPU();
        String other$limitCPU = other.getLimitCPU();
        if (this$limitCPU == null ? other$limitCPU != null : !this$limitCPU.equals(other$limitCPU)) {
            return false;
        }
        String this$limitMemory = this.getLimitMemory();
        String other$limitMemory = other.getLimitMemory();
        if (this$limitMemory == null ? other$limitMemory != null : !this$limitMemory.equals(other$limitMemory)) {
            return false;
        }
        List<String> this$mavenProfiles = this.getMavenProfiles();
        List<String> other$mavenProfiles = other.getMavenProfiles();
        if (this$mavenProfiles == null ? other$mavenProfiles != null : !((Object)this$mavenProfiles).equals(other$mavenProfiles)) {
            return false;
        }
        Map<String, String> this$nodeSelector = this.getNodeSelector();
        Map<String, String> other$nodeSelector = other.getNodeSelector();
        if (this$nodeSelector == null ? other$nodeSelector != null : !((Object)this$nodeSelector).equals(other$nodeSelector)) {
            return false;
        }
        OrderStrategy this$orderStrategy = this.getOrderStrategy();
        OrderStrategy other$orderStrategy = other.getOrderStrategy();
        if (this$orderStrategy == null ? other$orderStrategy != null : !((Object)((Object)this$orderStrategy)).equals((Object)other$orderStrategy)) {
            return false;
        }
        List<String> this$platforms = this.getPlatforms();
        List<String> other$platforms = other.getPlatforms();
        if (this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms)) {
            return false;
        }
        List<String> this$properties = this.getProperties();
        List<String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$requestCPU = this.getRequestCPU();
        String other$requestCPU = other.getRequestCPU();
        if (this$requestCPU == null ? other$requestCPU != null : !this$requestCPU.equals(other$requestCPU)) {
            return false;
        }
        String this$requestMemory = this.getRequestMemory();
        String other$requestMemory = other.getRequestMemory();
        if (this$requestMemory == null ? other$requestMemory != null : !this$requestMemory.equals(other$requestMemory)) {
            return false;
        }
        Strategy this$strategy = this.getStrategy();
        Strategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy)) {
            return false;
        }
        List<String> this$tasks = this.getTasks();
        List<String> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        String this$tasksFilter = this.getTasksFilter();
        String other$tasksFilter = other.getTasksFilter();
        if (this$tasksFilter == null ? other$tasksFilter != null : !this$tasksFilter.equals(other$tasksFilter)) {
            return false;
        }
        List<String> this$tasksLimitCPU = this.getTasksLimitCPU();
        List<String> other$tasksLimitCPU = other.getTasksLimitCPU();
        if (this$tasksLimitCPU == null ? other$tasksLimitCPU != null : !((Object)this$tasksLimitCPU).equals(other$tasksLimitCPU)) {
            return false;
        }
        List<String> this$tasksLimitMemory = this.getTasksLimitMemory();
        List<String> other$tasksLimitMemory = other.getTasksLimitMemory();
        if (this$tasksLimitMemory == null ? other$tasksLimitMemory != null : !((Object)this$tasksLimitMemory).equals(other$tasksLimitMemory)) {
            return false;
        }
        List<String> this$tasksRequestCPU = this.getTasksRequestCPU();
        List<String> other$tasksRequestCPU = other.getTasksRequestCPU();
        if (this$tasksRequestCPU == null ? other$tasksRequestCPU != null : !((Object)this$tasksRequestCPU).equals(other$tasksRequestCPU)) {
            return false;
        }
        List<String> this$tasksRequestMemory = this.getTasksRequestMemory();
        List<String> other$tasksRequestMemory = other.getTasksRequestMemory();
        return !(this$tasksRequestMemory == null ? other$tasksRequestMemory != null : !((Object)this$tasksRequestMemory).equals(other$tasksRequestMemory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Builder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $incrementalImageBuild = this.getIncrementalImageBuild();
        result = result * 59 + ($incrementalImageBuild == null ? 43 : ((Object)$incrementalImageBuild).hashCode());
        Boolean $verbose = this.getVerbose();
        result = result * 59 + ($verbose == null ? 43 : ((Object)$verbose).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $baseImage = this.getBaseImage();
        result = result * 59 + ($baseImage == null ? 43 : $baseImage.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $limitCPU = this.getLimitCPU();
        result = result * 59 + ($limitCPU == null ? 43 : $limitCPU.hashCode());
        String $limitMemory = this.getLimitMemory();
        result = result * 59 + ($limitMemory == null ? 43 : $limitMemory.hashCode());
        List<String> $mavenProfiles = this.getMavenProfiles();
        result = result * 59 + ($mavenProfiles == null ? 43 : ((Object)$mavenProfiles).hashCode());
        Map<String, String> $nodeSelector = this.getNodeSelector();
        result = result * 59 + ($nodeSelector == null ? 43 : ((Object)$nodeSelector).hashCode());
        OrderStrategy $orderStrategy = this.getOrderStrategy();
        result = result * 59 + ($orderStrategy == null ? 43 : ((Object)((Object)$orderStrategy)).hashCode());
        List<String> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        List<String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $requestCPU = this.getRequestCPU();
        result = result * 59 + ($requestCPU == null ? 43 : $requestCPU.hashCode());
        String $requestMemory = this.getRequestMemory();
        result = result * 59 + ($requestMemory == null ? 43 : $requestMemory.hashCode());
        Strategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        List<String> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        String $tasksFilter = this.getTasksFilter();
        result = result * 59 + ($tasksFilter == null ? 43 : $tasksFilter.hashCode());
        List<String> $tasksLimitCPU = this.getTasksLimitCPU();
        result = result * 59 + ($tasksLimitCPU == null ? 43 : ((Object)$tasksLimitCPU).hashCode());
        List<String> $tasksLimitMemory = this.getTasksLimitMemory();
        result = result * 59 + ($tasksLimitMemory == null ? 43 : ((Object)$tasksLimitMemory).hashCode());
        List<String> $tasksRequestCPU = this.getTasksRequestCPU();
        result = result * 59 + ($tasksRequestCPU == null ? 43 : ((Object)$tasksRequestCPU).hashCode());
        List<String> $tasksRequestMemory = this.getTasksRequestMemory();
        result = result * 59 + ($tasksRequestMemory == null ? 43 : ((Object)$tasksRequestMemory).hashCode());
        return result;
    }

    public static enum OrderStrategy {
        DEPENDENCIES("dependencies"),
        FIFO("fifo"),
        SEQUENTIAL("sequential");

        String value;

        private OrderStrategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum Strategy {
        POD("pod"),
        ROUTINE("routine");

        String value;

        private Strategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

