/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationstatus.conditions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationstatus.conditions.Pods;
import org.apache.camel.v1.integrationstatus.conditions.pods.Condition;
import org.apache.camel.v1.integrationstatus.conditions.pods.ConditionBuilder;
import org.apache.camel.v1.integrationstatus.conditions.pods.ConditionFluent;
import org.apache.camel.v1.integrationstatus.conditions.pods.Health;
import org.apache.camel.v1.integrationstatus.conditions.pods.HealthBuilder;
import org.apache.camel.v1.integrationstatus.conditions.pods.HealthFluent;

public class PodsFluent<A extends PodsFluent<A>>
extends BaseFluent<A> {
    private ConditionBuilder condition;
    private ArrayList<HealthBuilder> health;
    private String name;

    public PodsFluent() {
    }

    public PodsFluent(Pods instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Pods instance) {
        Pods pods = instance = instance != null ? instance : new Pods();
        if (instance != null) {
            this.withCondition(instance.getCondition());
            this.withHealth(instance.getHealth());
            this.withName(instance.getName());
        }
    }

    public Condition buildCondition() {
        return this.condition != null ? this.condition.build() : null;
    }

    public A withCondition(Condition condition) {
        this._visitables.remove((Object)"condition");
        if (condition != null) {
            this.condition = new ConditionBuilder(condition);
            this._visitables.get((Object)"condition").add(this.condition);
        } else {
            this.condition = null;
            this._visitables.get((Object)"condition").remove((Object)this.condition);
        }
        return (A)((Object)this);
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public ConditionNested<A> withNewCondition() {
        return new ConditionNested(null);
    }

    public ConditionNested<A> withNewConditionLike(Condition item) {
        return new ConditionNested(item);
    }

    public ConditionNested<A> editCondition() {
        return this.withNewConditionLike(Optional.ofNullable(this.buildCondition()).orElse(null));
    }

    public ConditionNested<A> editOrNewCondition() {
        return this.withNewConditionLike(Optional.ofNullable(this.buildCondition()).orElse(new ConditionBuilder().build()));
    }

    public ConditionNested<A> editOrNewConditionLike(Condition item) {
        return this.withNewConditionLike(Optional.ofNullable(this.buildCondition()).orElse(item));
    }

    public A addToHealth(int index, Health item) {
        if (this.health == null) {
            this.health = new ArrayList();
        }
        HealthBuilder builder = new HealthBuilder(item);
        if (index < 0 || index >= this.health.size()) {
            this._visitables.get((Object)"health").add(builder);
            this.health.add(builder);
        } else {
            this._visitables.get((Object)"health").add(index, builder);
            this.health.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHealth(int index, Health item) {
        if (this.health == null) {
            this.health = new ArrayList();
        }
        HealthBuilder builder = new HealthBuilder(item);
        if (index < 0 || index >= this.health.size()) {
            this._visitables.get((Object)"health").add(builder);
            this.health.add(builder);
        } else {
            this._visitables.get((Object)"health").set(index, builder);
            this.health.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHealth(Health ... items) {
        if (this.health == null) {
            this.health = new ArrayList();
        }
        for (Health item : items) {
            HealthBuilder builder = new HealthBuilder(item);
            this._visitables.get((Object)"health").add(builder);
            this.health.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPodsHealth(Collection<Health> items) {
        if (this.health == null) {
            this.health = new ArrayList();
        }
        for (Health item : items) {
            HealthBuilder builder = new HealthBuilder(item);
            this._visitables.get((Object)"health").add(builder);
            this.health.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHealth(Health ... items) {
        if (this.health == null) {
            return (A)((Object)this);
        }
        for (Health item : items) {
            HealthBuilder builder = new HealthBuilder(item);
            this._visitables.get((Object)"health").remove((Object)builder);
            this.health.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPodsHealth(Collection<Health> items) {
        if (this.health == null) {
            return (A)((Object)this);
        }
        for (Health item : items) {
            HealthBuilder builder = new HealthBuilder(item);
            this._visitables.get((Object)"health").remove((Object)builder);
            this.health.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPodsHealth(Predicate<HealthBuilder> predicate) {
        if (this.health == null) {
            return (A)((Object)this);
        }
        Iterator<HealthBuilder> each = this.health.iterator();
        List visitables = this._visitables.get((Object)"health");
        while (each.hasNext()) {
            HealthBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Health> buildHealth() {
        return this.health != null ? PodsFluent.build(this.health) : null;
    }

    public Health buildHealth(int index) {
        return this.health.get(index).build();
    }

    public Health buildFirstHealth() {
        return this.health.get(0).build();
    }

    public Health buildLastHealth() {
        return this.health.get(this.health.size() - 1).build();
    }

    public Health buildMatchingHealth(Predicate<HealthBuilder> predicate) {
        for (HealthBuilder item : this.health) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHealth(Predicate<HealthBuilder> predicate) {
        for (HealthBuilder item : this.health) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHealth(List<Health> health) {
        if (this.health != null) {
            this._visitables.get((Object)"health").clear();
        }
        if (health != null) {
            this.health = new ArrayList();
            for (Health item : health) {
                this.addToHealth(item);
            }
        } else {
            this.health = null;
        }
        return (A)((Object)this);
    }

    public A withHealth(Health ... health) {
        if (this.health != null) {
            this.health.clear();
            this._visitables.remove((Object)"health");
        }
        if (health != null) {
            for (Health item : health) {
                this.addToHealth(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHealth() {
        return this.health != null && !this.health.isEmpty();
    }

    public HealthNested<A> addNewHealth() {
        return new HealthNested(-1, null);
    }

    public HealthNested<A> addNewHealthLike(Health item) {
        return new HealthNested(-1, item);
    }

    public HealthNested<A> setNewHealthLike(int index, Health item) {
        return new HealthNested(index, item);
    }

    public HealthNested<A> editHealth(int index) {
        if (this.health.size() <= index) {
            throw new RuntimeException("Can't edit health. Index exceeds size.");
        }
        return this.setNewHealthLike(index, this.buildHealth(index));
    }

    public HealthNested<A> editFirstHealth() {
        if (this.health.size() == 0) {
            throw new RuntimeException("Can't edit first health. The list is empty.");
        }
        return this.setNewHealthLike(0, this.buildHealth(0));
    }

    public HealthNested<A> editLastHealth() {
        int index = this.health.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last health. The list is empty.");
        }
        return this.setNewHealthLike(index, this.buildHealth(index));
    }

    public HealthNested<A> editMatchingHealth(Predicate<HealthBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.health.size(); ++i) {
            if (!predicate.test(this.health.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching health. No match found.");
        }
        return this.setNewHealthLike(index, this.buildHealth(index));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodsFluent that = (PodsFluent)((Object)o);
        if (!Objects.equals((Object)this.condition, (Object)that.condition)) {
            return false;
        }
        if (!Objects.equals(this.health, that.health)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.condition, this.health, this.name, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.condition != null) {
            sb.append("condition:");
            sb.append(this.condition + ",");
        }
        if (this.health != null && !this.health.isEmpty()) {
            sb.append("health:");
            sb.append(this.health + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionNested<N>
    extends ConditionFluent<ConditionNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;

        ConditionNested(Condition item) {
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)PodsFluent.this.withCondition(this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class HealthNested<N>
    extends HealthFluent<HealthNested<N>>
    implements Nested<N> {
        HealthBuilder builder;
        int index;

        HealthNested(int index, Health item) {
            this.index = index;
            this.builder = new HealthBuilder(this, item);
        }

        public N and() {
            return (N)PodsFluent.this.setToHealth(this.index, this.builder.build());
        }

        public N endPodsHealth() {
            return this.and();
        }
    }
}

