/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.storm;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.messaging.storm.Storm;
import org.apache.brooklyn.entity.messaging.storm.StormDeployment;
import org.apache.brooklyn.entity.stock.BasicStartableImpl;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperEnsemble;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormDeploymentImpl
extends BasicStartableImpl
implements StormDeployment {
    private static final Logger log = LoggerFactory.getLogger(StormDeploymentImpl.class);

    public void init() {
        super.init();
        new ResourceUtils((Object)this).checkUrlExists((String)Storm.STORM_CONFIG_TEMPLATE_URL.getDefaultValue());
        this.setDefaultDisplayName("Storm Deployment");
        ZooKeeperEnsemble zooKeeperEnsemble = (ZooKeeperEnsemble)this.addChild((EntitySpec)EntitySpec.create(ZooKeeperEnsemble.class).configure(ZooKeeperEnsemble.INITIAL_SIZE, this.getConfig(ZOOKEEPERS_COUNT)));
        this.config().set(Storm.ZOOKEEPER_ENSEMBLE, (Object)zooKeeperEnsemble);
        Storm nimbus = (Storm)this.addChild((EntitySpec)EntitySpec.create(Storm.class).configure(Storm.ROLE, (Object)Storm.Role.NIMBUS));
        this.config().set(Storm.NIMBUS_ENTITY, (Object)nimbus);
        this.config().set(Storm.START_MUTEX, new Object());
        this.addChild((EntitySpec)((EntitySpec)((EntitySpec)EntitySpec.create(DynamicCluster.class).configure(DynamicCluster.MEMBER_SPEC, (Object)EntitySpec.create(Storm.class).configure(Storm.ROLE, (Object)Storm.Role.SUPERVISOR))).configure((ConfigKey)DynamicCluster.INITIAL_SIZE, this.getConfig(SUPERVISORS_COUNT))).displayName("Storm Supervisor Cluster"));
        Storm ui = (Storm)this.addChild((EntitySpec)EntitySpec.create(Storm.class).configure(Storm.ROLE, (Object)Storm.Role.UI));
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{Storm.STORM_UI_URL}).from((Entity)ui)).build());
        this.enrichers().add(((Enrichers.PropagatorBuilder)Enrichers.builder().propagating(new Sensor[]{Attributes.HOSTNAME}).from((Entity)nimbus)).build());
    }
}

