/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.kafka;

import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.messaging.kafka.AbstractfKafkaSshDriver;
import org.apache.brooklyn.entity.messaging.kafka.KafkaBroker;
import org.apache.brooklyn.entity.messaging.kafka.KafkaBrokerDriver;
import org.apache.brooklyn.entity.messaging.kafka.KafkaBrokerImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBrokerSshDriver
extends AbstractfKafkaSshDriver
implements KafkaBrokerDriver {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBrokerSshDriver.class);

    public KafkaBrokerSshDriver(KafkaBrokerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    @Override
    protected Map<String, Integer> getPortMap() {
        return MutableMap.of((Object)"kafkaPort", (Object)this.getKafkaPort());
    }

    @Override
    protected ConfigKey<String> getConfigTemplateKey() {
        return KafkaBroker.KAFKA_BROKER_CONFIG_TEMPLATE;
    }

    @Override
    protected String getConfigFileName() {
        return "server.properties";
    }

    @Override
    protected String getLaunchScriptName() {
        return "kafka-server-start.sh";
    }

    @Override
    public String getTopicsScriptName() {
        return "kafka-topics.sh";
    }

    @Override
    protected String getProcessIdentifier() {
        return "kafka\\.Kafka";
    }

    @Override
    public Integer getKafkaPort() {
        return (Integer)this.getEntity().getAttribute((AttributeSensor)KafkaBroker.KAFKA_PORT);
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        UsesJmx.JmxAgentModes jmxAgentMode = (UsesJmx.JmxAgentModes)this.getEntity().getConfig(KafkaBroker.JMX_AGENT_MODE);
        String jmxPort = jmxAgentMode == UsesJmx.JmxAgentModes.NONE ? String.valueOf(this.entity.getAttribute((AttributeSensor)UsesJmx.JMX_PORT)) : String.valueOf(this.entity.getAttribute((AttributeSensor)KafkaBroker.INTERNAL_JMX_PORT));
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"JMX_PORT", (Object)jmxPort).build();
    }
}

