/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.multi;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.location.NoMachinesAvailableException;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.cloud.AbstractAvailabilityZoneExtension;
import org.apache.brooklyn.core.location.cloud.AvailabilityZoneExtension;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;

public class MultiLocation<T extends MachineLocation>
extends AbstractLocation
implements MachineProvisioningLocation<T> {
    @Beta
    public static final ConfigKey<List<LocationSpec<?>>> SUB_LOCATION_SPECS = ConfigKeys.newConfigKey(new TypeToken<List<LocationSpec<?>>>(){}, "subLocationSpecs", "Specs of sub-locations that should be immediatly instantiated on init");
    public static final ConfigKey<List<MachineProvisioningLocation<?>>> SUB_LOCATIONS = ConfigKeys.newConfigKey(new TypeToken<List<MachineProvisioningLocation<?>>>(){}, "subLocations", "The sub-locations that this location can delegate to");

    /*
     * WARNING - void declaration
     */
    @Override
    public void init() {
        super.init();
        MutableList subLocs = MutableList.copyOf((Iterable)this.getConfig(SUB_LOCATIONS));
        List<LocationSpec<?>> subLocSpecs = this.getConfig(SUB_LOCATION_SPECS);
        if (subLocSpecs != null) {
            for (LocationSpec<?> locationSpec : subLocSpecs) {
                void var4_4;
                if (locationSpec.getParent() == null) {
                    LocationSpec locationSpec2 = LocationSpec.create(locationSpec).parent((Location)this);
                }
                MachineProvisioningLocation subLoc = (MachineProvisioningLocation)this.getManagementContext().getLocationManager().createLocation((LocationSpec)var4_4);
                subLocs.add(subLoc);
            }
        }
        Preconditions.checkState((subLocs.size() >= 1 ? 1 : 0) != 0, (Object)"sub-locations must not be empty");
        this.config().set(SUB_LOCATIONS, subLocs);
        this.config().set(SUB_LOCATION_SPECS, null);
        AvailabilityZoneExtensionImpl azExtension = new AvailabilityZoneExtensionImpl(this.getManagementContext(), (List<MachineProvisioningLocation<?>>)subLocs);
        this.addExtension(AvailabilityZoneExtension.class, azExtension);
    }

    public T obtain() throws NoMachinesAvailableException {
        return this.obtain((Map<?, ?>)MutableMap.of());
    }

    public T obtain(Map<?, ?> flags) throws NoMachinesAvailableException {
        String msg;
        Exception wrapped;
        List<MachineProvisioningLocation<?>> sublocsList = this.getSubLocations();
        Iterator<MachineProvisioningLocation<?>> sublocs = sublocsList.iterator();
        MutableList errors = MutableList.of();
        while (sublocs.hasNext()) {
            try {
                return (T)sublocs.next().obtain(flags);
            }
            catch (NoMachinesAvailableException e) {
                errors.add(e);
            }
        }
        if (errors.size() > 1) {
            wrapped = new CompoundRuntimeException(errors.size() + " sublocation exceptions, including: " + Exceptions.collapseText((Throwable)((Throwable)errors.get(0))), (Iterable)errors);
            msg = Exceptions.collapseText((Throwable)wrapped);
        } else if (errors.size() == 1) {
            wrapped = (Exception)errors.get(0);
            msg = wrapped.getMessage();
            if (Strings.isBlank((CharSequence)msg)) {
                msg = wrapped.toString();
            }
        } else {
            msg = "no sub-locations set for this multi-location";
            wrapped = null;
        }
        throw new NoMachinesAvailableException("No machines available in any of the " + sublocsList.size() + " location" + Strings.s((int)sublocsList.size()) + " configured here: " + msg, (Throwable)wrapped);
    }

    public List<MachineProvisioningLocation<?>> getSubLocations() {
        return this.getRequiredConfig(SUB_LOCATIONS);
    }

    public MachineProvisioningLocation<T> newSubLocation(Map<?, ?> newFlags) {
        return (MachineProvisioningLocation)this.getManagementContext().getLocationManager().createLocation((LocationSpec)((LocationSpec)LocationSpec.create(this.getClass()).parent((Location)this).configure(this.config().getLocalBag().getAllConfig())).configure(newFlags));
    }

    public void release(T machine) {
        ((MachineProvisioningLocation)machine.getParent()).release(machine);
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        return Maps.newLinkedHashMap();
    }

    protected MachineProvisioningLocation<T> firstSubLoc() {
        return (MachineProvisioningLocation)Iterables.get(this.getSubLocations(), (int)0);
    }

    protected <K> K getRequiredConfig(ConfigKey<K> key) {
        return (K)Preconditions.checkNotNull(this.getConfig(key), (Object)key.getName());
    }

    public static class AvailabilityZoneExtensionImpl
    extends AbstractAvailabilityZoneExtension
    implements AvailabilityZoneExtension {
        private final List<MachineProvisioningLocation<?>> subLocations;

        public AvailabilityZoneExtensionImpl(ManagementContext managementContext, List<MachineProvisioningLocation<?>> subLocations) {
            super(managementContext);
            this.subLocations = ImmutableList.copyOf(subLocations);
        }

        @Override
        protected List<Location> doGetAllSubLocations() {
            return ImmutableList.copyOf(this.subLocations);
        }

        @Override
        protected boolean isNameMatch(Location loc, Predicate<? super String> namePredicate) {
            return namePredicate.apply((Object)loc.getDisplayName());
        }
    }
}

