/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.plan;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.brooklyn.api.framework.FrameworkLookup;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.plan.PlanNotRecognizedException;
import org.apache.brooklyn.core.plan.PlanToSpecTransformer;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class PlanToSpecFactory {
    private static final Logger log = LoggerFactory.getLogger(PlanToSpecFactory.class);
    private static Collection<Class<? extends PlanToSpecTransformer>> OVERRIDE;

    private static Collection<PlanToSpecTransformer> getAll(boolean includeDeprecated) {
        Iterable<PlanToSpecTransformer> transformers = FrameworkLookup.lookupAll(PlanToSpecTransformer.class);
        return ImmutableList.copyOf(includeDeprecated ? transformers : PlanToSpecFactory.filterDeprecated(transformers));
    }

    private static Iterable<PlanToSpecTransformer> filterDeprecated(Iterable<PlanToSpecTransformer> transformers) {
        MutableList result = MutableList.of();
        for (PlanToSpecTransformer t : transformers) {
            if (PlanToSpecFactory.isDeprecated(t.getClass())) continue;
            result.add(t);
        }
        return result;
    }

    private static boolean isDeprecated(Class<? extends PlanToSpecTransformer> c) {
        return c.getAnnotation(Deprecated.class) != null;
    }

    @SafeVarargs
    @VisibleForTesting
    public static synchronized void forceAvailable(Class<? extends PlanToSpecTransformer> ... classes) {
        OVERRIDE = Arrays.asList(classes);
    }

    public static synchronized void clearForced() {
        OVERRIDE = null;
    }

    public static Collection<PlanToSpecTransformer> all(ManagementContext mgmt) {
        return PlanToSpecFactory.all(mgmt, true);
    }

    public static Collection<PlanToSpecTransformer> all(ManagementContext mgmt, boolean includeSuperseded) {
        Collection<Class<? extends PlanToSpecTransformer>> override = OVERRIDE;
        ArrayList<PlanToSpecTransformer> result = new ArrayList<PlanToSpecTransformer>();
        if (override != null) {
            for (Class<? extends PlanToSpecTransformer> o1 : override) {
                try {
                    if (!includeSuperseded && PlanToSpecFactory.isDeprecated(o1)) continue;
                    result.add(o1.newInstance());
                }
                catch (Exception e) {
                    Exceptions.propagate((Throwable)e);
                }
            }
        } else {
            result.addAll(PlanToSpecFactory.getAll(includeSuperseded));
        }
        for (PlanToSpecTransformer t : result) {
            t.setManagementContext(mgmt);
        }
        return result;
    }

    @Beta
    public static PlanToSpecTransformer forPlanType(ManagementContext mgmt, String planType) {
        Collection<PlanToSpecTransformer> transformers = PlanToSpecFactory.all(mgmt);
        for (PlanToSpecTransformer transformer : transformers) {
            if (!transformer.accepts(planType)) continue;
            return transformer;
        }
        throw new IllegalStateException("PlanToSpecTransformer for plan type " + planType + " not found. Registered transformers are: " + transformers);
    }

    @Beta
    public static <T> Maybe<T> attemptWithLoaders(ManagementContext mgmt, boolean includeDeprecated, Function<PlanToSpecTransformer, T> f) {
        return PlanToSpecFactory.attemptWithLoaders(PlanToSpecFactory.all(mgmt, includeDeprecated), f);
    }

    public static <T> Maybe<T> attemptWithLoaders(Iterable<PlanToSpecTransformer> transformers, Function<PlanToSpecTransformer, T> f) {
        RuntimeException result;
        ArrayList<String> transformersWhoDontSupport = new ArrayList<String>();
        ArrayList<PropagatedRuntimeException> otherProblemsFromTransformers = new ArrayList<PropagatedRuntimeException>();
        for (PlanToSpecTransformer t : transformers) {
            try {
                Object result2 = f.apply((Object)t);
                if (result2 == null) {
                    transformersWhoDontSupport.add(t.getShortDescription() + " (returned null)");
                    continue;
                }
                return Maybe.of((Object)result2);
            }
            catch (PlanNotRecognizedException | UnsupportedTypePlanException e) {
                transformersWhoDontSupport.add(t.getShortDescription() + (Strings.isNonBlank((CharSequence)e.getMessage()) ? " (" + e.getMessage() + ")" : ""));
            }
            catch (Throwable e) {
                Exceptions.propagateIfFatal((Throwable)e);
                otherProblemsFromTransformers.add(new PropagatedRuntimeException("Transformer for " + t.getShortDescription() + " gave an error creating this plan: ", Exceptions.collapseText((Throwable)e), e));
            }
        }
        if (!otherProblemsFromTransformers.isEmpty()) {
            log.debug("Plan could not be transformed; failure will be propagated (other transformers tried = " + transformersWhoDontSupport + "): " + otherProblemsFromTransformers);
            result = otherProblemsFromTransformers.size() == 1 ? Exceptions.create(null, otherProblemsFromTransformers) : Exceptions.create((String)"All plan transformers failed", otherProblemsFromTransformers);
        } else {
            result = new UnsupportedTypePlanException("Invalid plan; format could not be recognized, trying with: " + transformersWhoDontSupport);
        }
        return Maybe.absent((Throwable)result);
    }
}

