/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;

class RebindToMachinePredicate
implements Predicate<ComputeMetadata> {
    final String rawId;
    final String rawHostname;
    final String rawRegion;

    public RebindToMachinePredicate(ConfigBag config) {
        this.rawId = (String)config.getStringKey("id");
        this.rawHostname = (String)config.getStringKey("hostname");
        this.rawRegion = (String)config.getStringKey("region");
    }

    public boolean apply(ComputeMetadata input) {
        if (this.rawId != null && (this.rawId.equals(input.getId()) || this.rawRegion != null && (this.rawRegion + "/" + this.rawId).equals(input.getId()))) {
            return true;
        }
        if (input instanceof NodeMetadata) {
            NodeMetadata node = (NodeMetadata)NodeMetadata.class.cast(input);
            if (this.rawHostname != null && this.rawHostname.equalsIgnoreCase(node.getHostname())) {
                return true;
            }
            if (this.rawHostname != null && node.getPublicAddresses().contains(this.rawHostname)) {
                return true;
            }
            if (this.rawId != null && this.rawId.equalsIgnoreCase(node.getHostname())) {
                return true;
            }
            if (this.rawId != null && node.getPublicAddresses().contains(this.rawId)) {
                return true;
            }
            if (this.rawId != null && this.rawId.equalsIgnoreCase(node.getProviderId())) {
                return true;
            }
            if (this.rawHostname != null && this.rawHostname.equalsIgnoreCase(node.getProviderId())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.rawId).add("hostname", (Object)this.rawHostname).add("region", (Object)this.rawRegion).toString();
    }
}

