/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.internal.ReplicationControllerOperationsImpl;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.DoneableDeploymentConfig;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.ClientDeployableScalableResource;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentConfigOperationsImpl
extends OpenShiftOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, ClientDeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>>
implements ClientDeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentConfigOperationsImpl.class);
    private static final String DEPLOYMENT_CONFIG_REF = "openshift.io/deployment-config.name";

    public DeploymentConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public DeploymentConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, DeploymentConfig item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, null, apiVersion, "deploymentconfigs", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.reaper = new DeploymentConfigReaper(this, client);
    }

    public DoneableDeploymentConfig edit() {
        if (this.isCascading().booleanValue()) {
            return (DoneableDeploymentConfig)this.cascading(false).edit();
        }
        return (DoneableDeploymentConfig)super.edit();
    }

    public DeploymentConfig replace(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).replace((Object)item);
        }
        return (DeploymentConfig)super.replace((HasMetadata)item);
    }

    public DeploymentConfig patch(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).patch((Object)item);
        }
        return (DeploymentConfig)super.patch((HasMetadata)item);
    }

    @Override
    public DeploymentConfig deployLatest() {
        return this.deployLatest(false);
    }

    @Override
    public DeploymentConfig deployLatest(boolean wait) {
        Long currentVersion = ((DeploymentConfig)this.getMandatory()).getStatus().getLatestVersion();
        currentVersion = currentVersion + 1L;
        DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.StatusNested)((DoneableDeploymentConfig)this.cascading(false).edit()).editStatus().withLatestVersion(currentVersion)).endStatus()).done();
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled();
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    public DeploymentConfig scale(int count) {
        return this.scale(count, false);
    }

    public DeploymentConfig scale(int count, boolean wait) {
        DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)this.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled();
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    private void waitUntilDeploymentConfigIsScaled() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference atomicDeploymentConfig = new AtomicReference();
        Runnable deploymentPoller = new Runnable(){

            @Override
            public void run() {
                int currentReplicas;
                DeploymentConfig deploymentConfig = (DeploymentConfig)DeploymentConfigOperationsImpl.this.getMandatory();
                atomicDeploymentConfig.set(deploymentConfig);
                int n = currentReplicas = deploymentConfig.getStatus().getReplicas() != null ? deploymentConfig.getStatus().getReplicas() : 0;
                if (deploymentConfig.getStatus().getObservedGeneration() >= deploymentConfig.getMetadata().getGeneration() && Objects.equals(deploymentConfig.getSpec().getReplicas(), currentReplicas)) {
                    countDownLatch.countDown();
                } else {
                    LOG.debug("Only {}/{} pods scheduled for DeploymentConfig: {} in namespace: {} seconds so waiting...", new Object[]{deploymentConfig.getStatus().getReplicas(), deploymentConfig.getSpec().getReplicas(), deploymentConfig.getMetadata().getName(), DeploymentConfigOperationsImpl.this.namespace});
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            poller.cancel(true);
            executor.shutdown();
            int currentReplicas = ((DeploymentConfig)atomicDeploymentConfig.get()).getStatus().getReplicas() != null ? ((DeploymentConfig)atomicDeploymentConfig.get()).getStatus().getReplicas() : 0;
            LOG.error("Only {}/{} pod(s) ready for DeploymentConfig: {} in namespace: {} - giving up", new Object[]{currentReplicas, ((DeploymentConfig)atomicDeploymentConfig.get()).getSpec().getReplicas(), ((DeploymentConfig)atomicDeploymentConfig.get()).getMetadata().getName(), this.namespace});
        }
    }

    private static class DeploymentConfigReaper
    implements Reaper {
        private final DeploymentConfigOperationsImpl operation;
        private final OkHttpClient client;

        public DeploymentConfigReaper(DeploymentConfigOperationsImpl operation, OkHttpClient client) {
            this.operation = operation;
            this.client = client;
        }

        public boolean reap() {
            DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)this.operation.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(0))).endSpec()).done();
            this.waitForObservedGeneration(deployment.getStatus().getObservedGeneration());
            Boolean reaped = (Boolean)this.operation.cascading(false).delete();
            HashMap<String, String> selector = new HashMap<String, String>();
            selector.put(DeploymentConfigOperationsImpl.DEPLOYMENT_CONFIG_REF, deployment.getMetadata().getName());
            if (selector != null && !selector.isEmpty()) {
                Boolean bl = (Boolean)new ReplicationControllerOperationsImpl(this.client, (Config)this.operation.getConfig(), this.operation.getNamespace()).withLabels(selector).delete();
            }
            return reaped;
        }

        private void waitForObservedGeneration(final long observedGeneration) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable deploymentPoller = new Runnable(){

                @Override
                public void run() {
                    DeploymentConfig deployment = (DeploymentConfig)DeploymentConfigReaper.this.operation.getMandatory();
                    if (observedGeneration <= deployment.getStatus().getObservedGeneration()) {
                        countDownLatch.countDown();
                    }
                }
            };
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 10L, TimeUnit.MILLISECONDS);
            try {
                countDownLatch.await(1L, TimeUnit.MINUTES);
                executor.shutdown();
            }
            catch (InterruptedException e) {
                poller.cancel(true);
                executor.shutdown();
                throw KubernetesClientException.launderThrowable((Throwable)e);
            }
        }
    }
}

