/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserFluent;
import java.util.ArrayList;
import java.util.List;

public class UserFluentImpl<A extends UserFluent<A>>
extends BaseFluent<A>
implements UserFluent<A> {
    private String apiVersion;
    private String fullName;
    private List<String> groups = new ArrayList<String>();
    private List<String> identities = new ArrayList<String>();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;

    public UserFluentImpl() {
    }

    public UserFluentImpl(User instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withFullName(instance.getFullName());
        this.withGroups(instance.getGroups());
        this.withIdentities(instance.getIdentities());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public A withFullName(String fullName) {
        this.fullName = fullName;
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public A withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public A addToIdentities(String ... items) {
        for (String item : items) {
            this.identities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromIdentities(String ... items) {
        for (String item : items) {
            this.identities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getIdentities() {
        return this.identities;
    }

    @Override
    public A withIdentities(List<String> identities) {
        this.identities.clear();
        if (identities != null) {
            for (String item : identities) {
                this.addToIdentities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withIdentities(String ... identities) {
        this.identities.clear();
        if (identities != null) {
            for (String item : identities) {
                this.addToIdentities(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public UserFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public UserFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public UserFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public UserFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public UserFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserFluentImpl that = (UserFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(that.fullName) : that.fullName != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.identities != null ? !this.identities.equals(that.identities) : that.identities != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<UserFluent.MetadataNested<N>>
    implements UserFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)UserFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

