/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.sensor.windows;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.AbstractAddSensorFeed;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshValueFunctions;
import org.apache.brooklyn.feed.windows.CmdFeed;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.internal.winrm.WinRmTool;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class WinRmCommandSensor<T>
extends AbstractAddSensorFeed<T> {
    private static final Logger LOG = LoggerFactory.getLogger(WinRmCommandSensor.class);
    public static final ConfigKey<String> SENSOR_COMMAND = ConfigKeys.newStringConfigKey((String)"command", (String)"SSH command to execute for sensor");
    public static final ConfigKey<String> SENSOR_EXECUTION_DIR = ConfigKeys.newStringConfigKey((String)"executionDir", (String)"Directory where the command should run; if not supplied, executes in the entity's run dir (or home dir if no run dir is defined); use '~' to always execute in the home dir, or 'custom-feed/' to execute in a custom-feed dir relative to the run dir");
    public static final ConfigKey<Map<String, String>> SENSOR_ENVIRONMENT = WinRmTool.ENVIRONMENT;
    protected final String command;
    protected final String executionDir;
    protected final Map<String, String> sensorEnv;

    public WinRmCommandSensor(ConfigBag params) {
        super(params);
        this.command = (String)Preconditions.checkNotNull((Object)params.get(SENSOR_COMMAND), (Object)"SSH command must be supplied when defining this sensor");
        this.executionDir = (String)params.get(SENSOR_EXECUTION_DIR);
        this.sensorEnv = (Map)params.get(SENSOR_ENVIRONMENT);
    }

    public void apply(final EntityLocal entity) {
        super.apply(entity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding WinRM sensor {} to {}", (Object)this.name, (Object)entity);
        }
        Boolean suppressDuplicates = (Boolean)EntityInitializers.resolve((ConfigBag)this.params, (ConfigKey)SUPPRESS_DUPLICATES);
        Duration logWarningGraceTimeOnStartup = (Duration)EntityInitializers.resolve((ConfigBag)this.params, (ConfigKey)LOG_WARNING_GRACE_TIME_ON_STARTUP);
        Duration logWarningGraceTime = (Duration)EntityInitializers.resolve((ConfigBag)this.params, (ConfigKey)LOG_WARNING_GRACE_TIME);
        Supplier<Map<String, String>> envSupplier = new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                Object env = MutableMap.copyOf((Map)((Map)entity.getConfig(SENSOR_ENVIRONMENT)));
                if (WinRmCommandSensor.this.sensorEnv != null) {
                    env.putAll(WinRmCommandSensor.this.sensorEnv);
                }
                try {
                    env = (Map)Tasks.resolveDeepValueExactly((Object)env, (TypeToken)new TypeToken<Map<String, String>>(){}, (ExecutionContext)((EntityInternal)entity).getExecutionContext());
                }
                catch (InterruptedException | ExecutionException e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                }
                ShellEnvironmentSerializer serializer = new ShellEnvironmentSerializer(((EntityInternal)entity).getManagementContext());
                return serializer.serialize((Map)env);
            }
        };
        Supplier<String> commandSupplier = new Supplier<String>(){

            public String get() {
                return WinRmCommandSensor.makeCommandExecutingInDirectory(WinRmCommandSensor.this.command, WinRmCommandSensor.this.executionDir, (Entity)entity);
            }
        };
        CommandPollConfig pollConfig = (CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)((CommandPollConfig)new CommandPollConfig(this.sensor).period(this.period)).env((Supplier)envSupplier).command((Supplier)commandSupplier).suppressDuplicates(Boolean.TRUE.equals(suppressDuplicates))).checkSuccess(SshValueFunctions.exitStatusEquals((int)0))).onFailureOrException(Functions.constant(null))).onSuccess(Functions.compose((Function)new Function<String, T>(){

            public T apply(String input) {
                return TypeCoercions.coerce((Object)Strings.trimEnd((String)input), (Class)WinRmCommandSensor.this.sensor.getType());
            }
        }, (Function)SshValueFunctions.stdout()))).logWarningGraceTimeOnStartup(logWarningGraceTimeOnStartup)).logWarningGraceTime(logWarningGraceTime);
        CmdFeed feed = (CmdFeed)((CmdFeed.Builder)((CmdFeed.Builder)CmdFeed.builder().entity((Entity)entity)).onlyIfServiceUp()).poll(pollConfig).build();
        entity.addFeed((Feed)feed);
    }

    @Beta
    public static String makeCommandExecutingInDirectory(String command, String executionDir, Entity entity) {
        String finalCommand = command;
        String execDir = executionDir;
        if (Strings.isNonBlank((CharSequence)execDir) && !"~".equals(execDir)) {
            finalCommand = "(if exist \"" + execDir + "\" (rundll32) else (mkdir \"" + execDir + "\")) && cd \"" + execDir + "\" && " + finalCommand;
        }
        return finalCommand;
    }
}

