/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.net;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.math.BitList;
import org.apache.brooklyn.util.math.BitUtils;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.text.Strings;

public class Cidr
implements Serializable {
    private static final long serialVersionUID = -4605909101590811958L;
    public static final Cidr UNIVERSAL = new Cidr(new int[0]);
    public static final Cidr _10 = new Cidr(10);
    public static final Cidr _172_16 = new Cidr("172.16.0.0/12");
    public static final Cidr _192_168 = new Cidr(192, 168);
    public static final Cidr CLASS_A = _10;
    public static final Cidr CLASS_B = _172_16;
    public static final Cidr CLASS_C = _192_168;
    public static final List<Cidr> PRIVATE_NETWORKS_RFC_1918 = ImmutableList.of((Object)_192_168, (Object)_172_16, (Object)_10);
    public static final Cidr _169_254;
    public static final Cidr LINK_LOCAL;
    public static final Cidr _127;
    public static final Cidr LOOPBACK;
    public static final List<Cidr> NON_PUBLIC_CIDRS;
    final int[] subnetBytes = new int[]{0, 0, 0, 0};
    final int length;

    public Cidr(String cidr) {
        int i;
        int slash;
        if (Strings.isBlank(cidr)) {
            cidr = "0.0.0.0/0";
        }
        if ((slash = cidr.indexOf(47)) == -1) {
            throw new IllegalArgumentException("CIDR should be of form 192.168.0.0/16 (missing slash); input=" + cidr);
        }
        String subnet = cidr.substring(0, slash);
        String lengthS = cidr.substring(slash + 1);
        this.length = Integer.parseInt(lengthS);
        String[] bytes = subnet.split("\\.");
        for (i = 0; i < this.length / 8; ++i) {
            this.subnetBytes[i] = Integer.parseInt(bytes[i]);
        }
        while (i < (this.length + 7) / 8) {
            this.subnetBytes[i] = BitUtils.unsigned(BitUtils.reverseBitSignificanceInByte(BitList.newInstanceFromBytes(BitUtils.reverseBitSignificanceInByte(Integer.parseInt(bytes[i]))).resized(this.length % 8).intValue()));
            ++i;
        }
    }

    public static boolean isCanonical(String cidr) {
        try {
            return cidr.equals(new Cidr(cidr).toString());
        }
        catch (Throwable e) {
            Exceptions.propagateIfFatal(e);
            return false;
        }
    }

    public Cidr(int ... unsignedBytes) {
        this.length = unsignedBytes.length * 8;
        System.arraycopy(unsignedBytes, 0, this.subnetBytes, 0, unsignedBytes.length);
    }

    public Cidr(int[] subnetBytes, int length) {
        this.length = length;
        if (subnetBytes.length > 4) {
            throw new IllegalArgumentException("Cannot create CIDR beyond 4 bytes: " + Arrays.toString(subnetBytes));
        }
        if (length > 32) {
            throw new IllegalArgumentException("Cannot create CIDR beyond 4 bytes: length " + length);
        }
        byte[] significantSubnetBytes = BitList.newInstance(BitUtils.reverseBitSignificanceInBytes(subnetBytes)).resized(length).asBytes();
        for (int i = 0; i < significantSubnetBytes.length; ++i) {
            this.subnetBytes[i] = BitUtils.unsigned(BitUtils.reverseBitSignificance(significantSubnetBytes[i]));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + Arrays.hashCode(this.subnetBytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cidr other = (Cidr)obj;
        if (this.length != other.length) {
            return false;
        }
        return Arrays.equals(this.subnetBytes, other.subnetBytes);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < (this.length + 7) / 8; ++i) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append("" + this.subnetBytes[i]);
        }
        while (i < 4) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append("0");
            ++i;
        }
        sb.append("/");
        sb.append("" + this.length);
        return sb.toString();
    }

    public int[] getBytes() {
        return Arrays.copyOf(this.subnetBytes, 4);
    }

    public int getLength() {
        return this.length;
    }

    public Cidr subnet(int ... extraUnsignedBytes) {
        if (this.length % 8 != 0) {
            throw new IllegalStateException("subnet can only be used for byte boundary subnetted CIDR's; not " + this);
        }
        int[] newBytes = this.getBytes();
        int newLen = this.length + extraUnsignedBytes.length * 8;
        if (newLen > 32) {
            throw new IllegalStateException("further subnet for " + Arrays.toString(extraUnsignedBytes) + " not possible on CIDR " + this);
        }
        for (int i = 0; i < extraUnsignedBytes.length; ++i) {
            newBytes[this.length / 8 + i] = extraUnsignedBytes[i];
        }
        return new Cidr(newBytes, newLen);
    }

    public InetAddress netmask() {
        byte[] netmaskBytes = new byte[]{0, 0, 0, 0};
        int lengthLeft = this.length;
        int i = 0;
        while (lengthLeft > 0) {
            netmaskBytes[i] = lengthLeft >= 8 ? -1 : (byte)((1 << lengthLeft) - 1);
            lengthLeft -= 8;
            ++i;
        }
        return Networking.getInetAddressWithFixedName(netmaskBytes);
    }

    public InetAddress addressAtOffset(int offset) {
        int[] ints = this.getBytes();
        ints[3] = ints[3] + offset;
        int i = 3;
        while (ints[i] >= 256) {
            int n = i - 1;
            ints[n] = ints[n] + ints[i] / 256;
            int n2 = i--;
            ints[n2] = ints[n2] % 256;
        }
        byte[] bytes = new byte[]{0, 0, 0, 0};
        for (int i2 = 0; i2 < 4; ++i2) {
            bytes[i2] = (byte)ints[i2];
        }
        return Networking.getInetAddressWithFixedName(bytes);
    }

    public int commonPrefixLength(Cidr other) {
        return this.asBitList().commonPrefixLength(other.asBitList());
    }

    public Cidr commonPrefix(Cidr other) {
        return new Cidr(other.getBytes(), this.commonPrefixLength(other));
    }

    public BitList asBitList() {
        return BitList.newInstance(BitUtils.reverseBitSignificanceInBytes(this.getBytes())).resized(this.getLength());
    }

    public boolean contains(Cidr target) {
        return this.commonPrefixLength(target) == this.getLength();
    }

    @Deprecated
    public static InetAddress getInetAddressWithFixedName(byte[] ip) {
        return Networking.getInetAddressWithFixedName(ip);
    }

    static {
        LINK_LOCAL = _169_254 = new Cidr("169.254.0.0/16");
        LOOPBACK = _127 = new Cidr("127.0.0.0/8");
        NON_PUBLIC_CIDRS = ImmutableList.builder().addAll(PRIVATE_NETWORKS_RFC_1918).add((Object)LINK_LOCAL).add((Object)LOOPBACK).build();
    }
}

