/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.nodejs;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.webapp.WebAppService;
import org.apache.brooklyn.entity.webapp.WebAppServiceMethods;
import org.apache.brooklyn.entity.webapp.nodejs.NodeJsWebAppDriver;
import org.apache.brooklyn.entity.webapp.nodejs.NodeJsWebAppService;
import org.apache.brooklyn.entity.webapp.nodejs.NodeJsWebAppServiceImpl;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.file.ArchiveUtils;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsWebAppSshDriver
extends AbstractSoftwareProcessSshDriver
implements NodeJsWebAppDriver {
    private static final Logger LOG = LoggerFactory.getLogger(NodeJsWebAppService.class);

    public NodeJsWebAppSshDriver(NodeJsWebAppServiceImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public NodeJsWebAppServiceImpl getEntity() {
        return (NodeJsWebAppServiceImpl)super.getEntity();
    }

    @Override
    public Integer getHttpPort() {
        return (Integer)this.getEntity().getAttribute((AttributeSensor)Attributes.HTTP_PORT);
    }

    @Override
    public String getAppDir() {
        return Os.mergePaths((String[])new String[]{this.getRunDir(), (String)this.getEntity().getConfig(NodeJsWebAppService.APP_NAME)});
    }

    public void postLaunch() {
        String rootUrl = WebAppServiceMethods.inferBrooklynAccessibleRootUrl((Entity)this.entity);
        this.entity.sensors().set(Attributes.MAIN_URI, (Object)URI.create(rootUrl));
        this.entity.sensors().set(WebAppService.ROOT_URL, (Object)rootUrl);
    }

    protected Map<String, Integer> getPortMap() {
        return MutableMap.of((Object)"http", (Object)this.getHttpPort());
    }

    public Set<Integer> getPortsUsed() {
        return ImmutableSet.builder().addAll((Iterable)super.getPortsUsed()).addAll(this.getPortMap().values()).build();
    }

    public void prepare() {
        super.prepare();
        Networking.checkPortsValid(this.getPortMap());
    }

    public void install() {
        LOG.info("Installing Node.JS {}", (Object)this.getVersion());
        MutableList commands = MutableList.builder().add((Object)BashCommands.INSTALL_CURL).add((Object)BashCommands.ifExecutableElse0((String)"apt-get", (String)BashCommands.chain((String[])new String[]{BashCommands.installPackage((String)"software-properties-common python-software-properties python g++ make"), BashCommands.sudo((String)"add-apt-repository ppa:chris-lea/node.js")}))).add((Object)BashCommands.installPackage((Map)MutableMap.of((Object)"yum", (Object)"git openssl nodejs npm", (Object)"apt", (Object)"git-core nodejs npm"), null)).add((Object)"mkdir -p \"$HOME/.npm\"").add((Object)BashCommands.sudo((String)"npm install -g n")).add((Object)BashCommands.sudo((String)("n " + this.getVersion()))).build();
        this.newScript((String)"installing").body.append((Collection)commands).execute();
    }

    public void customize() {
        LinkedList commands = Lists.newLinkedList();
        String gitRepoUrl = (String)this.getEntity().getConfig(NodeJsWebAppService.APP_GIT_REPOSITORY_URL);
        String archiveUrl = (String)this.getEntity().getConfig(NodeJsWebAppService.APP_ARCHIVE_URL);
        String appName = (String)this.getEntity().getConfig(NodeJsWebAppService.APP_NAME);
        if (Strings.isNonBlank((CharSequence)gitRepoUrl) && Strings.isNonBlank((CharSequence)archiveUrl)) {
            throw new IllegalStateException("Only one of Git or archive URL must be set for " + this.getEntity());
        }
        if (Strings.isNonBlank((CharSequence)gitRepoUrl)) {
            commands.add(String.format("git clone %s %s", gitRepoUrl, appName));
            commands.add(String.format("cd %s", appName));
        } else if (Strings.isNonBlank((CharSequence)archiveUrl)) {
            ArchiveUtils.deploy((String)archiveUrl, (SshMachineLocation)this.getMachine(), (String)this.getRunDir());
        } else {
            throw new IllegalStateException("At least one of Git or archive URL must be set for " + this.getEntity());
        }
        commands.add(BashCommands.ifFileExistsElse1((String)"package.json", (String)"npm install"));
        List packages = (List)this.getEntity().getConfig(NodeJsWebAppService.NODE_PACKAGE_LIST);
        if (packages != null && packages.size() > 0) {
            commands.add(BashCommands.sudo((String)("npm install -g " + Joiner.on((char)' ').join((Iterable)packages))));
        }
        this.newScript((String)"customizing").body.append((Collection)commands).execute();
    }

    public void launch() {
        LinkedList commands = Lists.newLinkedList();
        String appName = (String)this.getEntity().getConfig(NodeJsWebAppService.APP_NAME);
        String appFile = (String)this.getEntity().getConfig(NodeJsWebAppService.APP_FILE);
        String appCommand = (String)this.getEntity().getConfig(NodeJsWebAppService.APP_COMMAND);
        String appCommandLine = (String)this.getEntity().getConfig(NodeJsWebAppService.APP_COMMAND_LINE);
        if (Strings.isBlank((CharSequence)appCommandLine)) {
            appCommandLine = appCommand + " " + appFile;
        }
        commands.add("export NODE_PATH=\"$NODE_PATH:$(npm root -g)\"");
        commands.add(String.format("cd %s", Os.mergePathsUnix((String[])new String[]{this.getRunDir(), appName})));
        commands.add("nohup " + appCommandLine + " > console.out 2>&1 &");
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").body.append((Collection)commands).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }

    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"PORT", (Object)Integer.toString(this.getHttpPort())).build();
    }
}

