/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.proxy;

import java.net.URI;
import java.util.Set;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.proxy.AbstractControllerImpl;
import org.apache.brooklyn.entity.proxy.LoadBalancer;
import org.apache.brooklyn.entity.proxy.ProxySslConfig;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=AbstractControllerImpl.class)
public interface AbstractController
extends SoftwareProcess,
LoadBalancer {
    @SetFromFlag(value="domain")
    public static final BasicAttributeSensorAndConfigKey<String> DOMAIN_NAME = new BasicAttributeSensorAndConfigKey(String.class, "proxy.domainName", "Domain name that this controller responds to, or null if it responds to all domains", null);
    @SetFromFlag(value="ssl")
    public static final ConfigKey<ProxySslConfig> SSL_CONFIG = ConfigKeys.newConfigKey(ProxySslConfig.class, (String)"proxy.ssl.config", (String)"Configuration (e.g. certificates) for SSL; causes server to run with HTTPS instead of HTTP");
    @SetFromFlag(value="serviceUpUrlPath")
    public static final ConfigKey<String> SERVICE_UP_URL_PATH = ConfigKeys.newStringConfigKey((String)"controller.config.serviceUpUrlPath", (String)"The path that will be appended to the root URL to determine SERVICE_UP", (String)"");
    public static final AttributeSensor<URI> MAIN_URI_MAPPED_SUBNET = Attributes.MAIN_URI_MAPPED_SUBNET;
    public static final AttributeSensor<URI> MAIN_URI_MAPPED_PUBLIC = Attributes.MAIN_URI_MAPPED_PUBLIC;

    public boolean isActive();

    public ProxySslConfig getSslConfig();

    public boolean isSsl();

    public String getProtocol();

    public String getDomain();

    public Integer getPort();

    public String getUrl();

    public AttributeSensor<Integer> getPortNumberSensor();

    public AttributeSensor<String> getHostnameSensor();

    public AttributeSensor<String> getHostAndPortSensor();

    public Set<String> getServerPoolAddresses();
}

