/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class Locks {
    public static <T> T withLock(Lock lock, Callable<T> body) {
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate(e);
        }
        try {
            T e = body.call();
            return e;
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
        finally {
            lock.unlock();
        }
    }

    public static void withLock(Lock lock, Runnable body) {
        Locks.withLock(lock, () -> {
            body.run();
            return null;
        });
    }
}

