/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group.zoneaware;

import com.google.common.annotations.Beta;
import com.google.common.base.Ticker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.entity.group.DynamicCluster;

@Beta
public abstract class AbstractZoneFailureDetector
implements DynamicCluster.ZoneFailureDetector {
    private final ConcurrentMap<Location, ZoneHistory> zoneHistories = Maps.newConcurrentMap();
    protected final Ticker ticker;

    public AbstractZoneFailureDetector() {
        this(Ticker.systemTicker());
    }

    public AbstractZoneFailureDetector(Ticker ticker) {
        this.ticker = ticker;
    }

    @Override
    public void onStartupSuccess(Location loc, Entity entity) {
        this.getZoneHistory(loc).onSuccess(this.currentTimeMillis());
    }

    @Override
    public void onStartupFailure(Location loc, Entity entity, Throwable cause) {
        this.getZoneHistory(loc).onFailure(this.currentTimeMillis(), cause);
    }

    @Override
    public boolean hasFailed(Location loc) {
        ZoneHistory zoneHistory = this.getZoneHistory(loc);
        return this.doHasFailed(loc, zoneHistory);
    }

    protected long currentTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.ticker.read());
    }

    protected ZoneHistory getZoneHistory(Location loc) {
        ZoneHistory zoneHistory = (ZoneHistory)this.zoneHistories.get(loc);
        if (zoneHistory == null) {
            ZoneHistory newZoneHistory = this.newZoneHistory(loc);
            ZoneHistory oldZoneHistory = this.zoneHistories.putIfAbsent(loc, newZoneHistory);
            zoneHistory = oldZoneHistory != null ? oldZoneHistory : newZoneHistory;
        }
        return zoneHistory;
    }

    protected ZoneHistory newZoneHistory(Location loc) {
        return new ZoneHistory();
    }

    protected abstract boolean doHasFailed(Location var1, ZoneHistory var2);

    public static class ZoneHistory {
        public final List<Long> successes = Lists.newLinkedList();
        public final List<Long> failures = Lists.newLinkedList();
        public final List<Throwable> causes = Lists.newLinkedList();

        public synchronized void onSuccess(long date) {
            this.successes.add(date);
        }

        public synchronized void onFailure(long date, Throwable cause) {
            this.failures.add(date);
            this.causes.add(cause);
        }

        public synchronized void trimOlderThan(long date) {
            assert (this.failures.size() == this.causes.size()) : this.failures.size() + " failures, but " + this.causes.size() + " causes; bad synchronization by callers";
            Iterator<Long> iter = this.successes.iterator();
            while (iter.hasNext()) {
                Long d = iter.next();
                if (d >= date) continue;
                iter.remove();
            }
            iter = this.failures.iterator();
            while (iter.hasNext()) {
                Iterator<Throwable> causeIter = this.causes.iterator();
                Long d = iter.next();
                causeIter.next();
                if (d >= date) break;
                iter.remove();
                causeIter.remove();
            }
        }
    }
}

