/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.geo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Durations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostExternalIpLoader {
    public static final Logger LOG = LoggerFactory.getLogger(LocalhostExternalIpLoader.class);
    private static final Object mutex = new Object();
    private static CountDownLatch retrievingLocalExternalIp;
    private static volatile String localExternalIp;

    @VisibleForTesting
    static List<String> getIpAddressWebsites() {
        String file = new ResourceUtils(LocalhostExternalIpLoader.class).getResourceAsString("classpath://org/apache/brooklyn/location/geo/external-ip-address-resolvers.txt");
        Iterable lines = Splitter.on((char)'\n').omitEmptyStrings().trimResults().split((CharSequence)file);
        ArrayList urls = Lists.newArrayList((Iterable)Iterables.filter((Iterable)lines, (Predicate)Predicates.not((Predicate)StringPredicates.startsWith((String)"#"))));
        Collections.shuffle(urls);
        return urls;
    }

    @VisibleForTesting
    static String getIpAddressFrom(String url) {
        return new IpLoader(url).call();
    }

    public static String getLocalhostIpQuicklyOrDefault() {
        String result = LocalhostExternalIpLoader.doLoad(Duration.seconds((Number)2));
        if (result == null) {
            return "127.0.0.1";
        }
        return result;
    }

    public static String getLocalhostIpWaiting() {
        return LocalhostExternalIpLoader.getLocalhostIpWithin(null);
    }

    public static String getLocalhostIpWithin(Duration timeout) {
        String result = LocalhostExternalIpLoader.doLoad(timeout);
        if (result == null) {
            throw new IllegalStateException("Unable to retrieve external IP for localhost; network may be down or slow or remote service otherwise not responding");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doLoad(Duration blockFor) {
        CountDownLatch attemptToRetrieveLocalExternalIp;
        boolean startAttemptToLoadIp;
        String resolvedIp = localExternalIp;
        if (resolvedIp != null) {
            return resolvedIp;
        }
        Object object = mutex;
        synchronized (object) {
            if (retrievingLocalExternalIp == null) {
                retrievingLocalExternalIp = new CountDownLatch(1);
                startAttemptToLoadIp = true;
            } else {
                startAttemptToLoadIp = false;
            }
            attemptToRetrieveLocalExternalIp = retrievingLocalExternalIp;
        }
        if (startAttemptToLoadIp) {
            final List<String> candidateUrls = LocalhostExternalIpLoader.getIpAddressWebsites();
            if (candidateUrls.isEmpty()) {
                LOG.debug("No candidate URLs to use to determine external IP of localhost");
                return null;
            }
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    for (String url : candidateUrls) {
                        try {
                            LOG.debug("Looking up external IP of this host from {} in private thread {}", (Object)url, (Object)Thread.currentThread());
                            String loadedIp = new IpLoader(url).call();
                            localExternalIp = loadedIp;
                            LOG.debug("Finished looking up external IP of this host from {} in private thread, result {}", (Object)url, (Object)loadedIp);
                            break;
                        }
                        catch (Throwable t) {
                            LOG.debug("Unable to look up external IP of this host from {}, probably offline {})", (Object)url, (Object)t);
                        }
                    }
                    attemptToRetrieveLocalExternalIp.countDown();
                    Object object = mutex;
                    synchronized (object) {
                        retrievingLocalExternalIp = null;
                    }
                }
            }.start();
        }
        try {
            if (blockFor != null) {
                Durations.await((CountDownLatch)attemptToRetrieveLocalExternalIp, (Duration)blockFor);
            } else {
                attemptToRetrieveLocalExternalIp.await();
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return localExternalIp;
    }

    private static class IpLoader
    implements Callable<String> {
        private static final Pattern ipPattern = Pattern.compile("\\b((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\b");
        final String url;

        protected IpLoader(String url) {
            this.url = url;
        }

        @Override
        public String call() {
            String response = ResourceUtils.create(LocalhostExternalIpLoader.class).getResourceAsString(this.url).trim();
            return this.postProcessResponse(response);
        }

        String postProcessResponse(String response) {
            Matcher matcher = ipPattern.matcher(response);
            boolean matched = matcher.find();
            if (!matched) {
                LOG.error("No IP address matched in output from {}: {}", (Object)this.url, (Object)response);
                return null;
            }
            return matcher.group();
        }
    }
}

