/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.FileInputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.ssl.Certificates;

public class X509CertificateChainBuilder {
    public static X509Certificate[] buildPath(X509Certificate startingPoint, Certificate[] certificates) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, CertificateException {
        return X509CertificateChainBuilder.buildPath(startingPoint, new LinkedList<Certificate>(Arrays.asList(certificates)));
    }

    public static X509Certificate[] buildPath(X509Certificate startingPoint, Collection certificates) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, CertificateException {
        LinkedList<X509Certificate> path = new LinkedList<X509Certificate>();
        path.add(startingPoint);
        boolean nodeAdded = true;
        block0: while (nodeAdded) {
            nodeAdded = false;
            X509Certificate top = (X509Certificate)path.getLast();
            if (X509CertificateChainBuilder.isSelfSigned(top)) break;
            Iterator it = certificates.iterator();
            while (it.hasNext()) {
                X509Certificate x509 = (X509Certificate)it.next();
                if (!X509CertificateChainBuilder.verify(top, x509.getPublicKey())) continue;
                path.add(x509);
                nodeAdded = true;
                it.remove();
                continue block0;
            }
        }
        X509Certificate[] results = new X509Certificate[path.size()];
        path.toArray(results);
        return results;
    }

    public static boolean isSelfSigned(X509Certificate cert) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        return X509CertificateChainBuilder.verify(cert, cert.getPublicKey());
    }

    public static boolean verify(X509Certificate cert, PublicKey key) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        String sigAlg = cert.getSigAlgName();
        String keyAlg = key.getAlgorithm();
        sigAlg = sigAlg != null ? sigAlg.trim().toUpperCase() : "";
        String string = keyAlg = keyAlg != null ? keyAlg.trim().toUpperCase() : "";
        if (keyAlg.length() >= 2 && sigAlg.endsWith(keyAlg)) {
            try {
                cert.verify(key);
                return true;
            }
            catch (SignatureException se) {
                return false;
            }
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: [special-one] [file-with-certs]");
            System.exit(1);
        }
        FileInputStream f1 = new FileInputStream(args[0]);
        FileInputStream f2 = new FileInputStream(args[1]);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate theOne = (X509Certificate)cf.generateCertificate(f1);
        Collection<? extends Certificate> c = cf.generateCertificates(f2);
        X509Certificate[] path = X509CertificateChainBuilder.buildPath(theOne, c);
        for (int i = 0; i < path.length; ++i) {
            System.out.println(Certificates.getCN(path[i]));
        }
    }
}

