/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.common.base.Preconditions;
import org.jclouds.googlecomputeengine.domain.Deprecated;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.options.AutoValue_ImageCreationOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class ImageCreationOptions {
    public abstract String name();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract String sourceType();

    @Nullable
    public abstract Image.RawDisk rawDisk();

    @Nullable
    public abstract Deprecated deprecated();

    @Nullable
    public abstract String sourceDisk();

    @SerializedNames(value={"name", "description", "sourceType", "rawDisk", "deprecated", "sourceDisk"})
    static ImageCreationOptions create(String name, String description, String sourceType, Image.RawDisk rawDisk, Deprecated deprecated, String sourceDisk) {
        return new AutoValue_ImageCreationOptions(name, description, sourceType, rawDisk, deprecated, sourceDisk);
    }

    public static class Builder {
        public String name;
        public String description;
        public String sourceType;
        public Image.RawDisk rawDisk;
        public Deprecated deprecated;
        public String sourceDisk;

        public Builder(String name) {
            this.name = name;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder rawDisk(Image.RawDisk rawDisk) {
            this.rawDisk = rawDisk;
            return this;
        }

        public Builder deprecated(Deprecated deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder sourceDisk(String sourceDisk) {
            this.sourceDisk = sourceDisk;
            return this;
        }

        public ImageCreationOptions build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"ImageCreationOptions: name cannot be null");
            return ImageCreationOptions.create(this.name, this.description, this.sourceType, this.rawDisk, this.deprecated, this.sourceDisk);
        }
    }
}

