/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding.impl;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.ws.WebServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.datasource.jaxb.JAXBDSContext;
import org.apache.axis2.datasource.jaxb.JAXBDataSource;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.databinding.JAXBBlock;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.impl.BlockImpl;
import org.apache.axis2.jaxws.message.util.XMLStreamWriterWithOS;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBBlockImpl
extends BlockImpl<Object, JAXBBlockContext>
implements JAXBBlock {
    private static final Log log = LogFactory.getLog(JAXBBlockImpl.class);
    private static final boolean DEBUG_ENABLED = log.isDebugEnabled();

    JAXBBlockImpl(Object busObject, JAXBBlockContext busContext, QName qName, BlockFactory factory) throws JAXBException {
        super(busObject, busContext, qName, factory);
    }

    JAXBBlockImpl(OMElement omElement, JAXBBlockContext busContext, QName qName, BlockFactory factory) {
        super(omElement, busContext, qName, factory);
    }

    @Override
    protected Object _getBOFromOM(OMElement omElement, JAXBBlockContext busContext) throws XMLStreamException, WebServiceException {
        if (omElement instanceof OMSourcedElement) {
            OMDataSource ds = ((OMSourcedElement)omElement).getDataSource();
            if (ds instanceof JAXBDataSource) {
                try {
                    JAXBDSContext dsContext = ((JAXBDataSource)ds).getContext();
                    busContext = new JAXBBlockContext(dsContext.getJAXBContext());
                }
                catch (JAXBException e) {
                    throw ExceptionFactory.makeWebServiceException((Throwable)e);
                }
                return ((JAXBDataSource)ds).getObject();
            }
            if (ds instanceof JAXBBlockImpl) {
                JAXBBlockContext blockContext;
                busContext = blockContext = (JAXBBlockContext)((JAXBBlockImpl)ds).getBusinessContext();
                return ((JAXBBlockImpl)ds).getObject();
            }
        }
        try {
            return busContext.unmarshal(omElement);
        }
        catch (JAXBException je) {
            if (DEBUG_ENABLED) {
                try {
                    log.debug((Object)("JAXBContext for unmarshal failure:" + String.valueOf(busContext.getJAXBContext(busContext.getClassLoader()))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)je);
        }
    }

    private byte[] _getBytesFromBO(Object busObj, JAXBBlockContext busContext, String encoding) throws XMLStreamException, WebServiceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLStreamWriterWithOS writer = new XMLStreamWriterWithOS(baos, encoding);
        this._outputFromBO(busObj, busContext, (XMLStreamWriter)writer);
        writer.flush();
        writer.close();
        return baos.toByteArray();
    }

    @Override
    protected XMLStreamReader _getReaderFromBO(Object busObj, JAXBBlockContext busContext) throws XMLStreamException, WebServiceException {
        ByteArrayInputStream baos = new ByteArrayInputStream(this._getBytesFromBO(busObj, busContext, "utf-8"));
        return StAXUtils.createXMLStreamReader((InputStream)baos, (String)"utf-8");
    }

    @Override
    protected void _outputFromBO(Object busObject, JAXBBlockContext busContext, XMLStreamWriter writer) throws XMLStreamException, WebServiceException {
        try {
            busContext.marshal(busObject, writer);
        }
        catch (JAXBException je) {
            if (DEBUG_ENABLED) {
                try {
                    log.debug((Object)("JAXBContext for marshal failure:" + String.valueOf(busContext.getJAXBContext(busContext.getClassLoader()))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)je);
        }
    }

    @Override
    public boolean isElementData() {
        return true;
    }

    public void close() {
    }

    public Object getObject() {
        try {
            return this.getBusinessObject(false);
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public boolean isDestructiveWrite() {
        return false;
    }

    @Override
    public OMDataSourceExt copy() throws OMException {
        if (DEBUG_ENABLED) {
            log.debug((Object)"Making a copy of the JAXB object");
        }
        return new JAXBDataSource(this.getObject(), (JAXBDSContext)this.getBusinessContext());
    }

    @Override
    public void setParent(Message message) {
        if (this.busContext != null) {
            ((JAXBBlockContext)this.busContext).setMessage(message);
        }
        super.setParent(message);
    }
}

