/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.javax.lang.model.util;

import org.openjdk.javax.annotation.processing.SupportedSourceVersion;
import org.openjdk.javax.lang.model.SourceVersion;
import org.openjdk.javax.lang.model.type.NoType;
import org.openjdk.javax.lang.model.type.PrimitiveType;
import org.openjdk.javax.lang.model.type.TypeKind;
import org.openjdk.javax.lang.model.util.SimpleTypeVisitor6;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class TypeKindVisitor6<R, P>
extends SimpleTypeVisitor6<R, P> {
    @Deprecated
    protected TypeKindVisitor6() {
        super(null);
    }

    @Deprecated
    protected TypeKindVisitor6(R r) {
        super(r);
    }

    @Override
    public R visitPrimitive(PrimitiveType primitiveType, P p) {
        TypeKind typeKind = primitiveType.getKind();
        switch (typeKind) {
            case BOOLEAN: {
                return this.visitPrimitiveAsBoolean(primitiveType, p);
            }
            case BYTE: {
                return this.visitPrimitiveAsByte(primitiveType, p);
            }
            case SHORT: {
                return this.visitPrimitiveAsShort(primitiveType, p);
            }
            case INT: {
                return this.visitPrimitiveAsInt(primitiveType, p);
            }
            case LONG: {
                return this.visitPrimitiveAsLong(primitiveType, p);
            }
            case CHAR: {
                return this.visitPrimitiveAsChar(primitiveType, p);
            }
            case FLOAT: {
                return this.visitPrimitiveAsFloat(primitiveType, p);
            }
            case DOUBLE: {
                return this.visitPrimitiveAsDouble(primitiveType, p);
            }
        }
        throw new AssertionError((Object)("Bad kind " + (Object)((Object)typeKind) + " for PrimitiveType" + primitiveType));
    }

    public R visitPrimitiveAsBoolean(PrimitiveType primitiveType, P p) {
        return this.defaultAction(primitiveType, p);
    }

    public R visitPrimitiveAsByte(PrimitiveType primitiveType, P p) {
        return this.defaultAction(primitiveType, p);
    }

    public R visitPrimitiveAsShort(PrimitiveType primitiveType, P p) {
        return this.defaultAction(primitiveType, p);
    }

    public R visitPrimitiveAsInt(PrimitiveType primitiveType, P p) {
        return this.defaultAction(primitiveType, p);
    }

    public R visitPrimitiveAsLong(PrimitiveType primitiveType, P p) {
        return this.defaultAction(primitiveType, p);
    }

    public R visitPrimitiveAsChar(PrimitiveType primitiveType, P p) {
        return this.defaultAction(primitiveType, p);
    }

    public R visitPrimitiveAsFloat(PrimitiveType primitiveType, P p) {
        return this.defaultAction(primitiveType, p);
    }

    public R visitPrimitiveAsDouble(PrimitiveType primitiveType, P p) {
        return this.defaultAction(primitiveType, p);
    }

    @Override
    public R visitNoType(NoType noType, P p) {
        TypeKind typeKind = noType.getKind();
        switch (typeKind) {
            case VOID: {
                return this.visitNoTypeAsVoid(noType, p);
            }
            case PACKAGE: {
                return this.visitNoTypeAsPackage(noType, p);
            }
            case NONE: {
                return this.visitNoTypeAsNone(noType, p);
            }
        }
        throw new AssertionError((Object)("Bad kind " + (Object)((Object)typeKind) + " for NoType" + noType));
    }

    public R visitNoTypeAsVoid(NoType noType, P p) {
        return this.defaultAction(noType, p);
    }

    public R visitNoTypeAsPackage(NoType noType, P p) {
        return this.defaultAction(noType, p);
    }

    public R visitNoTypeAsNone(NoType noType, P p) {
        return this.defaultAction(noType, p);
    }
}

