/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import org.apache.axiom.attachments.LegacyTempFileBlob;
import org.apache.axiom.attachments.lifecycle.DataHandlerExt;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.mime.Part;
import org.apache.axiom.mime.PartDataHandler;

final class LegacyPartDataHandler
extends PartDataHandler
implements DataHandlerExt {
    LegacyPartDataHandler(Part part) {
        super(part);
    }

    @Override
    protected DataSource createDataSource(Part part, String contentType) {
        Blob blob = part.getBlob();
        if (blob instanceof LegacyTempFileBlob) {
            return ((LegacyTempFileBlob)blob).getDataSource(contentType);
        }
        return null;
    }

    @Override
    public InputStream readOnce() throws IOException {
        return this.getPart().getInputStream(false);
    }

    @Override
    public void purgeDataSource() throws IOException {
        this.getPart().discard();
    }

    @Override
    public void deleteWhenReadOnce() throws IOException {
        this.purgeDataSource();
    }
}

