/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.eclipse.ui;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.axis2.tool.service.bean.WSDLAutoGenerateOptionBean;
import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.axis2.tool.service.eclipse.ui.AbstractServiceWizardPage;
import org.apache.axis2.tool.service.eclipse.ui.ServiceArchiveWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class WSDLOptionsPage
extends AbstractServiceWizardPage {
    private static final String SERVICE_WSDL_DEFAULT_NAME = "service.wsdl";
    private Text classNameTextBox;
    private Text outputFileNameTextBox;
    private Combo styleSelectionCombo;
    private Button searchDeclaredMethodsCheckBox;
    private Table table;

    public WSDLOptionsPage() {
        super("page6");
    }

    @Override
    protected void initializeDefaultSettings() {
        this.settings.put("WSDL_FILE_NAME", SERVICE_WSDL_DEFAULT_NAME);
        this.settings.put("WSDL_CLASS_NAME", "");
        this.settings.put("WSDL_STYLE", 0);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(ServiceArchiver.getResourceString("page6.fileName.label"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.outputFileNameTextBox = new Text(container, 2048);
        this.outputFileNameTextBox.setLayoutData((Object)gd);
        this.outputFileNameTextBox.setText(this.settings.get("WSDL_FILE_NAME"));
        this.outputFileNameTextBox.setEnabled(false);
        this.outputFileNameTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSDLOptionsPage.this.handlFileNameModification();
            }
        });
        gd = new GridData(768);
        label = new Label(container, 0);
        label.setText(ServiceArchiver.getResourceString("page6.class.label"));
        this.classNameTextBox = new Text(container, 2048);
        this.classNameTextBox.setLayoutData((Object)gd);
        this.classNameTextBox.setText(this.settings.get("WSDL_CLASS_NAME"));
        this.classNameTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WSDLOptionsPage.this.handleClassNameModification();
            }
        });
        gd = new GridData(768);
        Button loadButton = new Button(container, 8);
        loadButton.setText("Load");
        loadButton.setLayoutData((Object)gd);
        loadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSDLOptionsPage.this.updateTable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.searchDeclaredMethodsCheckBox = new Button(container, 32);
        this.searchDeclaredMethodsCheckBox.setLayoutData((Object)gd);
        this.searchDeclaredMethodsCheckBox.setText("List Declared Methods Only");
        this.searchDeclaredMethodsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSDLOptionsPage.this.updateDirtyStatus(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(container, 0);
        label.setText(ServiceArchiver.getResourceString("page6.style.label"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.styleSelectionCombo = new Combo(container, 2060);
        this.styleSelectionCombo.setLayoutData((Object)gd);
        this.populateStyleCombo();
        this.styleSelectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WSDLOptionsPage.this.settings.put("WSDL_STYLE", WSDLOptionsPage.this.styleSelectionCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 5;
        this.table = new Table(container, 65572);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)gd);
        this.declareColumn(this.table, 20, "");
        this.declareColumn(this.table, 100, "Method Name");
        this.declareColumn(this.table, 100, "Return Type");
        this.declareColumn(this.table, 100, "Parameter Count");
        this.table.setVisible(false);
        this.setControl((Control)container);
    }

    private void declareColumn(Table table, int width, String colName) {
        TableColumn column = new TableColumn(table, 0);
        column.setWidth(width);
        column.setText(colName);
    }

    private void populateStyleCombo() {
        this.styleSelectionCombo.add("Document");
        this.styleSelectionCombo.add("rpc");
        this.styleSelectionCombo.add("Wrapped");
        this.styleSelectionCombo.select(this.settings.getInt("WSDL_STYLE"));
    }

    private void updateTable() {
        try {
            String classFileLocation = this.getClassFileLocation();
            URL classFileURL = new File(classFileLocation).toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{classFileURL});
            Class<?> clazz = loader.loadClass(this.classNameTextBox.getText());
            Method[] methods = null;
            methods = this.searchDeclaredMethodsCheckBox.getSelection() ? clazz.getDeclaredMethods() : clazz.getMethods();
            int methodCount = methods.length;
            if (methodCount > 0) {
                this.table.removeAll();
                TableItem[] items = new TableItem[methodCount];
                for (int i = 0; i < methodCount; ++i) {
                    items[i] = new TableItem(this.table, 0);
                    items[i].setText(1, methods[i].getName());
                    items[i].setText(2, methods[i].getReturnType().getName());
                    items[i].setText(3, methods[i].getParameterTypes().length + "");
                    items[i].setChecked(true);
                }
                this.table.setVisible(true);
                this.updateDirtyStatus(false);
                this.updateStatus(null);
            }
        }
        catch (MalformedURLException e) {
            this.updateStatus("Error : invalid location " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            this.updateStatus("Error : Class not found " + e.getMessage());
        }
    }

    private void handleClassNameModification() {
        String className = this.classNameTextBox.getText();
        this.settings.put("WSDL_CLASS_NAME", className);
        if (className == null || "".equals(className.trim())) {
            this.updateStatus(ServiceArchiver.getResourceString("page6.error.classname1"));
        } else if (className.endsWith(".")) {
            this.updateStatus(ServiceArchiver.getResourceString("page6.error.classname2"));
        } else {
            this.updateStatus(null);
        }
    }

    private void handlFileNameModification() {
        String wsdlFileName = this.outputFileNameTextBox.getText();
        this.settings.put("WSDL_FILE_NAME", wsdlFileName);
        if (wsdlFileName == null || "".equals(wsdlFileName.trim())) {
            this.updateStatus(ServiceArchiver.getResourceString("page6.error.fileName1"));
        } else if (wsdlFileName.endsWith(".wsdl")) {
            this.updateStatus(ServiceArchiver.getResourceString("page6.error.fileName2"));
        } else {
            this.updateStatus(null);
        }
    }

    private String getClassFileLocation() {
        ServiceArchiveWizard wizard = (ServiceArchiveWizard)this.getWizard();
        return wizard.getClassFileLocation();
    }

    public WSDLAutoGenerateOptionBean getBean() {
        WSDLAutoGenerateOptionBean optionBean = new WSDLAutoGenerateOptionBean();
        optionBean.setClassFileName(this.classNameTextBox.getText());
        optionBean.setOutputFileName(this.outputFileNameTextBox.getText());
        optionBean.setStyle(this.styleSelectionCombo.getItem(this.styleSelectionCombo.getSelectionIndex()));
        return optionBean;
    }

    private void updateDirtyStatus(boolean status) {
        if (this.table.isVisible()) {
            this.table.setEnabled(!status);
        }
        this.setPageComplete(!status);
    }

    @Override
    protected boolean getWizardComplete() {
        return false;
    }
}

