/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.typedevent.bus.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.osgi.framework.Filter;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.ConverterFunction;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.osgi.util.converter.TypeReference;

public class EventConverter {
    private static final TypeReference<List<Object>> LIST_OF_OBJECTS = new TypeReference<List<Object>>(){};
    private static final TypeReference<Set<Object>> SET_OF_OBJECTS = new TypeReference<Set<Object>>(){};
    private static final TypeReference<Map<String, Object>> MAP_WITH_STRING_KEYS = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<Map<Object, Object>> MAP_OF_OBJECT_TO_OBJECT = new TypeReference<Map<Object, Object>>(){};
    private static final Converter eventConverter;
    private static final Set<Class<?>> safeClasses;
    private static final Set<Class<?>> specialClasses;
    private static final ThreadLocal<Set<Object>> errorsBeingHandled;
    private final Object originalEvent;
    private Map<String, ?> untypedEventDataForFiltering;

    static Object convert(Object o, Type target) {
        if (target != Object.class || o == null) {
            return ConverterFunction.CANNOT_HANDLE;
        }
        Class<?> sourceClass = o.getClass();
        if (safeClasses.contains(sourceClass)) {
            return o;
        }
        if (specialClasses.contains(sourceClass) || sourceClass.isEnum()) {
            return ((Converting)eventConverter.convert(o).sourceAs(Object.class)).to(String.class);
        }
        if (o instanceof Collection) {
            if (o instanceof Set) {
                return eventConverter.convert(o).to(SET_OF_OBJECTS);
            }
            return eventConverter.convert(o).to(LIST_OF_OBJECTS);
        }
        if (o instanceof Map) {
            return eventConverter.convert(o).to(MAP_OF_OBJECT_TO_OBJECT);
        }
        if (sourceClass.isArray()) {
            int depth = 1;
            Class<?> arrayComponentType = sourceClass.getComponentType();
            Class<?> actualComponentType = sourceClass.getComponentType();
            while (actualComponentType.isArray()) {
                ++depth;
                actualComponentType = actualComponentType.getComponentType();
            }
            if (safeClasses.contains(actualComponentType) || actualComponentType.isPrimitive()) {
                return o;
            }
            if (actualComponentType.isEnum()) {
                Class<?> stringArrayType = Array.newInstance(String.class, new int[depth]).getClass();
                return eventConverter.convert(o).to(stringArrayType);
            }
            List oList = (List)eventConverter.convert(o).to(LIST_OF_OBJECTS);
            return oList.toArray((Object[])Array.newInstance(arrayComponentType, 0));
        }
        return ((Converting)eventConverter.convert(o).sourceAsDTO()).to(MAP_WITH_STRING_KEYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object attemptRecovery(Object o, Type target) {
        if (o instanceof Map) {
            Set<Object> errors = errorsBeingHandled.get();
            if (errors.contains(o)) {
                return ConverterFunction.CANNOT_HANDLE;
            }
            try {
                errors.add(o);
                Object object = ((Converting)eventConverter.convert(o).targetAsDTO()).to(target);
                return object;
            }
            finally {
                errors.remove(o);
            }
        }
        return ConverterFunction.CANNOT_HANDLE;
    }

    private EventConverter(Object event) {
        this.originalEvent = event;
    }

    private EventConverter(Map<String, ?> untypedEvent) {
        this.originalEvent = untypedEvent;
        this.untypedEventDataForFiltering = untypedEvent;
    }

    public static EventConverter forTypedEvent(Object event) {
        return new EventConverter(event);
    }

    public static EventConverter forUntypedEvent(Map<String, ?> event) {
        return new EventConverter(event);
    }

    public boolean applyFilter(Filter f) {
        Map<String, ?> toTest = this.untypedEventDataForFiltering == null ? this.toUntypedEvent() : this.untypedEventDataForFiltering;
        return f.matches(toTest);
    }

    public Map<String, ?> toUntypedEvent() {
        if (this.untypedEventDataForFiltering == null) {
            this.untypedEventDataForFiltering = (Map)((Converting)eventConverter.convert(this.originalEvent).sourceAsDTO()).to(MAP_WITH_STRING_KEYS);
        }
        return this.untypedEventDataForFiltering;
    }

    public <T> T toTypedEvent(Class<T> clazz) {
        if (clazz.isInstance(this.originalEvent)) {
            return clazz.cast(this.originalEvent);
        }
        return (T)((Converting)eventConverter.convert(this.originalEvent).targetAsDTO()).to(clazz);
    }

    static {
        errorsBeingHandled = ThreadLocal.withInitial(() -> Collections.newSetFromMap(new IdentityHashMap()));
        safeClasses = new HashSet();
        safeClasses.add(String.class);
        safeClasses.add(Boolean.class);
        safeClasses.add(Byte.class);
        safeClasses.add(Short.class);
        safeClasses.add(Character.class);
        safeClasses.add(Integer.class);
        safeClasses.add(Long.class);
        safeClasses.add(Float.class);
        safeClasses.add(Double.class);
        specialClasses = new HashSet();
        specialClasses.add(Date.class);
        specialClasses.add(Calendar.class);
        specialClasses.add(Duration.class);
        specialClasses.add(Instant.class);
        specialClasses.add(LocalDate.class);
        specialClasses.add(LocalDateTime.class);
        specialClasses.add(LocalTime.class);
        specialClasses.add(MonthDay.class);
        specialClasses.add(OffsetTime.class);
        specialClasses.add(OffsetDateTime.class);
        specialClasses.add(Year.class);
        specialClasses.add(YearMonth.class);
        specialClasses.add(ZonedDateTime.class);
        specialClasses.add(UUID.class);
        eventConverter = Converters.standardConverter().newConverterBuilder().rule(EventConverter::convert).errorHandler(EventConverter::attemptRecovery).build();
    }
}

